/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.ExtractPairs;
import dr.evolution.alignment.GapUtils;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.inference.model.Parameter;
import dr.math.DifferentialEvolution;
import dr.math.MultivariateFunction;
import dr.math.UnivariateFunction;
import dr.math.UnivariateMinimum;
import dr.oldevomodel.sitemodel.GammaSiteModel;
import dr.oldevomodel.sitemodel.PairDistance;
import dr.oldevomodel.sitemodel.ScoreMatrix;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.HKY;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AlignmentScore
implements UnivariateFunction,
MultivariateFunction {
    SiteModel siteModel;
    ScoreMatrix scoreMatrix;
    SitePatterns sitePatterns;

    public AlignmentScore(ScoreMatrix scoreMatrix, SitePatterns sitePatterns) {
        this.scoreMatrix = scoreMatrix;
        this.siteModel = scoreMatrix.siteModel;
        this.sitePatterns = sitePatterns;
    }

    @Override
    public double evaluate(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        ((HKY)((GammaSiteModel)this.siteModel).getSubstitutionModel()).setKappa(d);
        this.scoreMatrix.setTime(d2);
        return -this.scoreMatrix.getScore(this.sitePatterns);
    }

    @Override
    public double evaluate(double d) {
        this.scoreMatrix.setTime(d);
        return -this.scoreMatrix.getScore(this.sitePatterns);
    }

    @Override
    public int getNumArguments() {
        return 2;
    }

    @Override
    public double getLowerBound() {
        return 0.0;
    }

    @Override
    public double getUpperBound() {
        return 10.0;
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        if (n == 0) {
            return 100.0;
        }
        if (n == 1) {
            return 100.0;
        }
        return 10.0;
    }

    public static double[] getAlignmentScore(ScoreMatrix scoreMatrix, SitePatterns sitePatterns) {
        AlignmentScore alignmentScore = new AlignmentScore(scoreMatrix, sitePatterns);
        double[] dArray = new double[alignmentScore.getNumArguments()];
        DifferentialEvolution differentialEvolution = new DifferentialEvolution(dArray.length, dArray.length * 10);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.5;
        }
        differentialEvolution.optimize(alignmentScore, dArray, 1.0E-6, 1.0E-6);
        double d = alignmentScore.evaluate(dArray);
        double[] dArray2 = new double[dArray.length + 1];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        dArray2[dArray.length] = d;
        return dArray2;
    }

    public static double getGeneticDistance(ScoreMatrix scoreMatrix, SitePatterns sitePatterns) {
        AlignmentScore alignmentScore = new AlignmentScore(scoreMatrix, sitePatterns);
        double[] dArray = new double[alignmentScore.getNumArguments()];
        DifferentialEvolution differentialEvolution = new DifferentialEvolution(dArray.length, dArray.length * 10);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.5;
        }
        differentialEvolution.optimize(alignmentScore, dArray, 1.0E-6, 1.0E-6);
        return dArray[dArray.length - 1];
    }

    public static double[] getFastAlignmentScore(ScoreMatrix scoreMatrix, SitePatterns sitePatterns) {
        AlignmentScore alignmentScore = new AlignmentScore(scoreMatrix, sitePatterns);
        UnivariateMinimum univariateMinimum = new UnivariateMinimum();
        double d = univariateMinimum.optimize(alignmentScore, 1.0E-6);
        double d2 = alignmentScore.evaluate(d);
        return new double[]{d, d2};
    }

    /*
     * WARNING - void declaration
     */
    private static void printFrequencyTable(List<Integer> list) {
        void var4_7;
        int n = 0;
        int n2 = 0;
        for (Integer object : list) {
            if (object > n) {
                n = object;
            }
            n2 += object.intValue();
        }
        Object object = new int[n + 1];
        for (Integer n3 : list) {
            Object object2 = object;
            int n4 = n3;
            object2[n4] = object2[n4] + true;
        }
        boolean bl = false;
        while (var4_7 < ((Object)object).length) {
            System.out.println((int)var4_7 + "\t" + (int)object[var4_7]);
            ++var4_7;
        }
        System.out.println("Total = " + n2);
    }

    public static void main(String[] stringArray) throws IOException, Importer.ImportException {
        Serializable serializable;
        int n;
        NexusImporter nexusImporter = new NexusImporter(new FileReader(stringArray[0]));
        Alignment alignment = nexusImporter.importAlignment();
        ExtractPairs extractPairs = new ExtractPairs(alignment);
        Parameter.Default default_ = new Parameter.Default(1.0);
        Parameter.Default default_2 = new Parameter.Default(1.0);
        default_2.addBounds(new Parameter.DefaultBounds(100.0, 0.0, 1));
        default_.addBounds(new Parameter.DefaultBounds(1.0, 1.0, 1));
        Parameter.Default default_3 = new Parameter.Default(alignment.getStateFrequencies());
        FrequencyModel frequencyModel = new FrequencyModel((DataType)Nucleotides.INSTANCE, default_3);
        HKY hKY = new HKY(default_2, frequencyModel);
        GammaSiteModel gammaSiteModel = new GammaSiteModel(hKY, default_, null, 1, null);
        ScoreMatrix scoreMatrix = new ScoreMatrix(gammaSiteModel, 0.1);
        double d = 0.1;
        ArrayList<PairDistance> arrayList = new ArrayList<PairDistance>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < alignment.getSequenceCount(); ++n) {
            for (int i = n + 1; i < alignment.getSequenceCount(); ++i) {
                Alignment object = extractPairs.getPairAlignment(n, i);
                if (object != null) {
                    serializable = new SitePatterns(object);
                    double d2 = AlignmentScore.getGeneticDistance(scoreMatrix, (SitePatterns)serializable);
                    if (d2 < d) {
                        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                        GapUtils.getGapSizes(object, arrayList3);
                        arrayList.add(new PairDistance(n, i, d2, arrayList3, object.getSiteCount()));
                        System.out.print(".");
                        continue;
                    }
                    System.out.print("*");
                    continue;
                }
                System.out.print("x");
            }
            System.out.println();
        }
        Collections.sort(arrayList);
        n = 0;
        for (PairDistance pairDistance : arrayList) {
            serializable = pairDistance.x;
            Integer n2 = pairDistance.y;
            if (hashSet.contains(serializable) || hashSet.contains(n2)) continue;
            arrayList2.addAll(pairDistance.gaps);
            hashSet.add((Integer)serializable);
            hashSet.add(n2);
            System.out.println("Added pair (" + serializable + "," + n2 + ") d=" + pairDistance.distance + " L=" + pairDistance.alignmentLength);
            n += pairDistance.alignmentLength;
        }
        AlignmentScore.printFrequencyTable(arrayList2);
        System.out.println("total length=" + n);
    }
}

