/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.lineage;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.Binomial;
import dr.oldevomodel.lineage.LineageSitePatterns;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LineageModelLikelihood
extends AbstractModelLikelihood {
    protected int numSamples;
    protected int numSNPs;
    protected int numLineages;
    protected double normalization;
    protected MatrixParameter mixtureMatrix;
    protected LineageSitePatterns patterns;
    protected Parameter errorRate;
    protected MatrixParameter refData;
    protected MatrixParameter nonData;
    protected boolean likelihoodKnown = false;
    protected double logLikelihood = 0.0;
    private double storedLogLikelihood;
    private boolean storedLikelihoodKnown = false;
    public static final String LINEAGE_MODEL = "LINEAGE_MODEL";
    public static final String LINEAGE_MODEL_PARSER = "lineageModel";
    public static final String MIXTURE = "mixture";
    public static final String REFERENCE = "ref";
    public static final String NON_REFERENCE = "non";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("mixture", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, false)}, false), new ElementRule("ref", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, false)}, false), new ElementRule("non", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, false)}, false), new ElementRule(LineageSitePatterns.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return LineageModelLikelihood.LINEAGE_MODEL_PARSER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = null;
            MatrixParameter matrixParameter2 = null;
            MatrixParameter matrixParameter3 = null;
            Parameter parameter = null;
            LineageSitePatterns lineageSitePatterns = null;
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (xMLObject.getChild(i) instanceof Parameter) {
                    parameter = (Parameter)xMLObject.getChild(i);
                    continue;
                }
                if (!(xMLObject.getChild(i) instanceof LineageSitePatterns)) continue;
                lineageSitePatterns = (LineageSitePatterns)xMLObject.getChild(i);
            }
            matrixParameter3 = (MatrixParameter)xMLObject.getElementFirstChild(LineageModelLikelihood.MIXTURE);
            matrixParameter2 = (MatrixParameter)xMLObject.getElementFirstChild(LineageModelLikelihood.REFERENCE);
            matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LineageModelLikelihood.NON_REFERENCE);
            if (parameter == null) {
                throw new XMLParseException("An element of class Parameter corresponding to error rate needs to be provided.");
            }
            if (lineageSitePatterns == null) {
                throw new XMLParseException("Lineage model-compatible site patterns need to be provided.");
            }
            if (matrixParameter.getColumnDimension() != matrixParameter2.getColumnDimension() || matrixParameter.getRowDimension() != matrixParameter2.getRowDimension() || matrixParameter3.getRowDimension() != matrixParameter2.getColumnDimension()) {
                System.err.println("REF " + matrixParameter2.getRowDimension() + " x " + matrixParameter2.getColumnDimension() + "\n");
                System.err.println("NON " + matrixParameter.getRowDimension() + " x " + matrixParameter.getColumnDimension() + "\n");
                System.err.println("MIXTURE " + matrixParameter3.getRowDimension() + " x " + matrixParameter3.getColumnDimension() + "\n");
                throw new XMLParseException("Some dimensions do not match, check your input data.");
            }
            return new LineageModelLikelihood(lineageSitePatterns, matrixParameter3, parameter, matrixParameter2, matrixParameter);
        }

        @Override
        public String getParserDescription() {
            return "A matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return LineageModelLikelihood.class;
        }
    };

    public LineageModelLikelihood(LineageSitePatterns lineageSitePatterns, MatrixParameter matrixParameter, Parameter parameter, MatrixParameter matrixParameter2, MatrixParameter matrixParameter3) {
        super(LINEAGE_MODEL);
        this.numSamples = matrixParameter.getRowDimension();
        this.numSNPs = lineageSitePatterns.getSiteCount();
        this.numLineages = matrixParameter.getColumnDimension();
        this.mixtureMatrix = matrixParameter;
        this.patterns = lineageSitePatterns;
        this.errorRate = parameter;
        this.refData = matrixParameter2;
        this.nonData = matrixParameter3;
        this.normalization = 0.0;
        for (int i = 0; i < this.numSNPs; ++i) {
            for (int j = 0; j < this.numSamples; ++j) {
                this.normalization += Binomial.logChoose(Math.round(matrixParameter2.getParameterValue(j, i) + matrixParameter3.getParameterValue(j, i)), Math.round(matrixParameter3.getParameterValue(j, i)));
            }
        }
        this.addVariable(parameter);
        this.addModel(lineageSitePatterns);
        this.addVariable(matrixParameter);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.mixtureMatrix || model == this.patterns || model == this.errorRate) {
            this.makeDirty();
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.storedLikelihoodKnown = this.likelihoodKnown;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = this.storedLikelihoodKnown;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    protected double calculateLogLikelihood() {
        double d = this.normalization;
        for (int i = 0; i < this.numSNPs; ++i) {
            for (int j = 0; j < this.numSamples; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < this.numLineages; ++k) {
                    d2 += this.mixtureMatrix.getParameterValue(k, j) * (double)(1 - this.patterns.getState(k, i));
                }
                d2 = d2 - 2.0 * this.errorRate.getParameterValue(0) * d2 + this.errorRate.getParameterValue(0);
                d += this.refData.getParameterValue(j, i) * Math.log(d2) + this.nonData.getParameterValue(j, i) * Math.log(1.0 - d2);
            }
        }
        return d;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }
}

