/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;

public class Vector {
    protected double[] components;

    public Vector(double[] dArray) throws NegativeArraySizeException {
        int n = dArray.length;
        if (n <= 0) {
            throw new NegativeArraySizeException("Vector components cannot be empty");
        }
        this.components = new double[n];
        System.arraycopy(dArray, 0, this.components, 0, n);
    }

    public Vector(int[] nArray) throws NegativeArraySizeException {
        int n = nArray.length;
        if (n <= 0) {
            throw new NegativeArraySizeException("Vector components cannot be empty");
        }
        this.components = new double[n];
        for (int i = 0; i < n; ++i) {
            this.components[i] = nArray[i];
        }
    }

    public Vector(int n) throws NegativeArraySizeException {
        if (n <= 0) {
            throw new NegativeArraySizeException("Requested vector size: " + n);
        }
        this.components = new double[n];
    }

    public void accumulate(double[] dArray) throws IllegalDimension {
        if (this.dimension() != dArray.length) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + dArray.length + "-dimension array");
        }
        for (int i = 0; i < this.dimension(); ++i) {
            int n = i;
            this.components[n] = this.components[n] + dArray[i];
        }
    }

    public void accumulate(Vector vector) throws IllegalDimension {
        if (this.dimension() != vector.dimension()) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + vector.dimension() + "-dimension vector");
        }
        for (int i = 0; i < this.dimension(); ++i) {
            int n = i;
            this.components[n] = this.components[n] + vector.components[i];
        }
    }

    public void accumulateNegated(double[] dArray) throws IllegalDimension {
        if (this.dimension() != dArray.length) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + dArray.length + "-dimension array");
        }
        for (int i = 0; i < this.dimension(); ++i) {
            int n = i;
            this.components[n] = this.components[n] - dArray[i];
        }
    }

    public void accumulateNegated(Vector vector) throws IllegalDimension {
        if (this.dimension() != vector.dimension()) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + vector.dimension() + "-dimension vector");
        }
        for (int i = 0; i < this.dimension(); ++i) {
            int n = i;
            this.components[n] = this.components[n] - vector.components[i];
        }
    }

    public Vector add(Vector vector) throws IllegalDimension {
        if (this.dimension() != vector.dimension()) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + vector.dimension() + "-dimension vector");
        }
        double[] dArray = new double[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            dArray[i] = this.components[i] + vector.components[i];
        }
        return new Vector(dArray);
    }

    public void clear() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = 0.0;
        }
    }

    public double component(int n) {
        return this.components[n];
    }

    public void set(int n, double d) {
        this.components[n] = d;
    }

    public int dimension() {
        return this.components.length;
    }

    public boolean equals(Vector vector) {
        int n = this.dimension();
        if (vector.dimension() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (vector.components[i] == this.components[i]) continue;
            return false;
        }
        return true;
    }

    public double norm() {
        double d = 0.0;
        for (int i = 0; i < this.components.length; ++i) {
            d += this.components[i] * this.components[i];
        }
        return Math.sqrt(d);
    }

    public Vector normalizedBy(double d) {
        int n = 0;
        while (n < this.dimension()) {
            int n2 = n++;
            this.components[n2] = this.components[n2] / d;
        }
        return this;
    }

    public Vector product(double d) {
        double[] dArray = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            dArray[i] = d * this.components[i];
        }
        return new Vector(dArray);
    }

    public double product(Vector vector) throws IllegalDimension {
        int n = vector.dimension();
        if (this.components.length != n) {
            throw new IllegalDimension("Dot product with mismatched dimensions: " + this.components.length + ", " + n);
        }
        return this.secureProduct(vector);
    }

    public Vector product(Matrix matrix) throws IllegalDimension {
        int n = matrix.rows();
        int n2 = matrix.columns();
        if (this.dimension() != n) {
            throw new IllegalDimension("Product error: transposed of a " + this.dimension() + "-dimension vector cannot be multiplied with a " + n + " by " + n2 + " matrix");
        }
        return this.secureProduct(matrix);
    }

    public Vector scaledBy(double d) {
        int n = 0;
        while (n < this.dimension()) {
            int n2 = n++;
            this.components[n2] = this.components[n2] * d;
        }
        return this;
    }

    protected double secureProduct(Vector vector) {
        double d = 0.0;
        for (int i = 0; i < vector.dimension(); ++i) {
            d += this.components[i] * vector.components[i];
        }
        return d;
    }

    protected Vector secureProduct(Matrix matrix) {
        int n = matrix.rows();
        int n2 = matrix.columns();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n3 = i;
                dArray[n3] = dArray[n3] + this.components[j] * matrix.components[j][i];
            }
        }
        return new Vector(dArray);
    }

    public Vector subtract(Vector vector) throws IllegalDimension {
        if (this.dimension() != vector.dimension()) {
            throw new IllegalDimension("Attempt to add a " + this.dimension() + "-dimension vector to a " + vector.dimension() + "-dimension vector");
        }
        double[] dArray = new double[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            dArray[i] = this.components[i] - vector.components[i];
        }
        return new Vector(dArray);
    }

    public Matrix tensorProduct(Vector vector) {
        int n = this.dimension();
        int n2 = vector.dimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.components[i] * vector.components[j];
            }
        }
        return n == n2 ? new SymmetricMatrix(dArray) : new Matrix(dArray);
    }

    public double[] toComponents() {
        int n = this.dimension();
        double[] dArray = new double[n];
        System.arraycopy(this.components, 0, dArray, 0, n);
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        for (int i = 0; i < this.components.length; ++i) {
            stringBuffer.append(cArray);
            stringBuffer.append(this.components[i]);
            cArray[0] = 44;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Vector buildOneTimesElementVector(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return new Vector(dArray);
    }
}

