/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class LUPDecomposition {
    private double[][] rows;
    private int[] permutation = null;
    private int parity = 1;

    public LUPDecomposition(double[][] dArray) throws IllegalDimension {
        int n = dArray.length;
        if (dArray[0].length != n) {
            throw new IllegalDimension("Illegal system: a" + n + " by " + dArray[0].length + " matrix is not a square matrix");
        }
        this.rows = dArray;
        this.initialize();
    }

    public LUPDecomposition(Matrix matrix) throws IllegalDimension {
        if (!matrix.isSquare()) {
            throw new IllegalDimension("Supplied matrix is not a square matrix");
        }
        this.initialize(matrix.components);
    }

    public LUPDecomposition(SymmetricMatrix symmetricMatrix) {
        this.initialize(symmetricMatrix.components);
    }

    private double[] backwardSubstitution(double[] dArray) {
        int n = this.rows.length;
        double[] dArray2 = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = dArray[i];
            for (int j = i + 1; j < n; ++j) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] - this.rows[i][j] * dArray2[j];
            }
            int n3 = i;
            dArray2[n3] = dArray2[n3] / this.rows[i][i];
        }
        return dArray2;
    }

    private void decompose() {
        int n;
        int n2 = this.rows.length;
        this.permutation = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.permutation[n] = n;
        }
        this.parity = 1;
        try {
            for (n = 0; n < n2; ++n) {
                this.swapRows(n, this.largestPivot(n));
                this.pivot(n);
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.parity = 0;
        }
    }

    private boolean decomposed() {
        if (this.parity == 1 && this.permutation == null) {
            this.decompose();
        }
        return this.parity != 0;
    }

    public double determinant() {
        if (!this.decomposed()) {
            return Double.NaN;
        }
        double d = this.parity;
        for (int i = 0; i < this.rows.length; ++i) {
            d *= this.rows[i][i];
        }
        return d;
    }

    public double logDeterminant() {
        if (!this.decomposed()) {
            return Double.NaN;
        }
        int n = this.parity;
        double d = 0.0;
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i][i] == 0.0) {
                return Double.NaN;
            }
            d += Math.log(Math.abs(this.rows[i][i]));
            n *= this.rows[i][i] > 0.0 ? 1 : -1;
        }
        if (n < 0) {
            return Double.NaN;
        }
        return d;
    }

    public boolean isPD() {
        for (int i = 0; i < this.rows.length; ++i) {
            if (!(this.rows[i][i] <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private double[] forwardSubstitution(double[] dArray) {
        int n = this.rows.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[this.permutation[i]];
            for (int j = 0; j <= i - 1; ++j) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] - this.rows[i][j] * dArray2[j];
            }
        }
        return dArray2;
    }

    private void initialize() {
        this.permutation = null;
        this.parity = 1;
    }

    private void initialize(double[][] dArray) {
        int n = dArray.length;
        this.rows = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.rows[i][j] = dArray[i][j];
            }
        }
        this.initialize();
    }

    public double[][] inverseMatrixComponents() {
        if (!this.decomposed()) {
            return null;
        }
        int n = this.rows.length;
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[n2] = 0.0;
            }
            dArray2[i] = 1.0;
            dArray2 = this.solve(dArray2);
            for (n2 = 0; n2 < n; ++n2) {
                dArray[i][n2] = dArray2[n2];
            }
        }
        return dArray;
    }

    private int largestPivot(int n) {
        double d = Math.abs(this.rows[n][n]);
        int n2 = n;
        for (int i = n + 1; i < this.rows.length; ++i) {
            double d2 = Math.abs(this.rows[i][n]);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    private void pivot(int n) {
        double d = 1.0 / this.rows[n][n];
        int n2 = n + 1;
        int n3 = this.rows.length;
        for (int i = n2; i < n3; ++i) {
            double[] dArray = this.rows[i];
            int n4 = n;
            dArray[n4] = dArray[n4] * d;
            for (int j = n2; j < n3; ++j) {
                double[] dArray2 = this.rows[i];
                int n5 = j;
                dArray2[n5] = dArray2[n5] - this.rows[i][n] * this.rows[n][j];
            }
        }
    }

    public double[] solve(double[] dArray) {
        return this.decomposed() ? this.backwardSubstitution(this.forwardSubstitution(dArray)) : null;
    }

    public Vector solve(Vector vector) {
        double[] dArray = this.solve(vector.components);
        if (dArray == null) {
            return null;
        }
        return dArray == null ? null : new Vector(dArray);
    }

    private void swapRows(int n, int n2) {
        if (n != n2) {
            int n3;
            for (n3 = 0; n3 < this.rows.length; ++n3) {
                double d = this.rows[n][n3];
                this.rows[n][n3] = this.rows[n2][n3];
                this.rows[n2][n3] = d;
            }
            n3 = this.permutation[n];
            this.permutation[n] = this.permutation[n2];
            this.permutation[n2] = n3;
            this.parity = -this.parity;
        }
    }

    public static void symmetrizeComponents(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                double[] dArray2 = dArray[i];
                int n = j;
                dArray2[n] = dArray2[n] + dArray[j][i];
                double[] dArray3 = dArray[i];
                int n2 = j;
                dArray3[n2] = dArray3[n2] * 0.5;
                dArray[j][i] = dArray[i][j];
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        int n2 = this.rows.length;
        for (n = 0; n < n2; ++n) {
            cArray[0] = 123;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.rows[n][i]);
                cArray[0] = 32;
            }
            stringBuffer.append('}');
            stringBuffer.append('\n');
        }
        if (this.permutation != null) {
            stringBuffer.append(this.parity == 1 ? (char)'+' : '-');
            stringBuffer.append("( " + this.permutation[0]);
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(", " + this.permutation[n]);
            }
            stringBuffer.append(')');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

