/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.GammaFunction;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class Gumbel2Distribution
implements Distribution,
GradientProvider {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return Gumbel2Distribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    double shape;
    double scale;

    public Gumbel2Distribution(double d, double d2) {
        this.shape = d;
        this.scale = d2;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double d) {
        this.shape = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    @Override
    public double pdf(double d) {
        return Gumbel2Distribution.pdf(d, this.shape, this.scale);
    }

    @Override
    public double logPdf(double d) {
        return Gumbel2Distribution.logPdf(d, this.shape, this.scale);
    }

    @Override
    public double cdf(double d) {
        return Gumbel2Distribution.cdf(d, this.shape, this.scale);
    }

    @Override
    public double quantile(double d) {
        return Gumbel2Distribution.quantile(d, this.shape, this.scale);
    }

    @Override
    public double mean() {
        return Gumbel2Distribution.mean(this.shape, this.scale);
    }

    @Override
    public double variance() {
        return Gumbel2Distribution.variance(this.shape, this.scale);
    }

    public double nextGumbel() {
        return Gumbel2Distribution.nextGumbel(this.shape, this.scale);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.exp(Gumbel2Distribution.logPdf(d, d2, d3));
    }

    public static double logPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d4 = Math.log(d2) + Math.log(d3) - (d2 + 1.0) * d - d3 * Math.pow(d, -d2);
        return d4;
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        return (-d2 * d3 * Math.pow(d, -d2) - d2 - 1.0) / d;
    }

    public static double hessianLogPdf(double d, double d2, double d3) {
        return (d2 + 1.0) * Math.pow(d, -d2 - 2.0) * (Math.pow(d, d2) + d2 * d3);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.exp(-d3 * Math.pow(d, -d2));
    }

    public static double quantile(double d, double d2, double d3) {
        return Math.pow(-d3 / Math.log(d), 1.0 / d2);
    }

    public static double mean(double d, double d2) {
        return Math.pow(d2, 1.0 / d) * Math.exp(GammaFunction.lnGamma(1.0 - 1.0 / d));
    }

    public static double variance(double d, double d2) {
        double d3 = Math.exp(GammaFunction.lnGamma(1.0 - 1.0 / d));
        return Math.pow(d2, 2.0 / d) * (d3 - Math.pow(d3, 2.0));
    }

    public static double nextGumbel(double d, double d2) {
        double d3 = MathUtils.nextDouble();
        return Gumbel2Distribution.quantile(d3, d, d2);
    }

    public static void main(String[] stringArray) {
        System.out.println("Test Gumbel type II");
        double d = 0.5;
        double d2 = 2.302585;
        Gumbel2Distribution gumbel2Distribution = new Gumbel2Distribution(d, d2);
        System.out.println("x = 2, pdf 0.01125111, logPdf -4.487288, median 11.03521");
        System.out.println("pdf = " + gumbel2Distribution.pdf(2.0));
        System.out.println("logPdf = " + gumbel2Distribution.logPdf(2.0));
        System.out.println("quantile(0.5) aka median = " + gumbel2Distribution.quantile(0.5));
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Gumbel2Distribution.gradLogPdf(dArray[i], this.shape, this.scale);
        }
        return dArray2;
    }
}

