/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class LogTricks {
    public static final double maxFloat = Double.MAX_VALUE;
    public static final double logLimit = -1.7976931348623156E306;
    public static final double logZero = -1.7976931348623157E308;
    public static final double NATS = 400.0;

    public static double logSumNoCheck(double d, double d2) {
        double d3 = d2 - d;
        if (Math.abs(d3) > 400.0) {
            return d > d2 ? d : d2;
        }
        return d + StrictMath.log1p(StrictMath.exp(d3));
    }

    public static double logSum(double[] dArray) {
        double d = dArray[0];
        int n = dArray.length;
        for (int i = 1; i < n; ++i) {
            d = LogTricks.logSumNoCheck(d, dArray[i]);
        }
        return d;
    }

    public static double logSum(double d, double d2) {
        double d3 = d2 - d;
        if (d3 > 400.0 || d < -1.7976931348623156E306) {
            return d2;
        }
        if (d3 < -400.0 || d2 < -1.7976931348623156E306) {
            return d;
        }
        if (d3 < 0.0) {
            return d + StrictMath.log1p(StrictMath.exp(d3));
        }
        return d2 + StrictMath.log1p(StrictMath.exp(-d3));
    }

    public static void logInc(Double d, double d2) {
        double d3 = d2 - d;
        if (d3 > 400.0 || d < -1.7976931348623156E306) {
            d = d2;
        } else if (!(d3 < -400.0) && !(d2 < -1.7976931348623156E306)) {
            d = d + StrictMath.log1p(StrictMath.exp(d3));
        }
    }

    public static double logDiff(double d, double d2) {
        assert (d > d2);
        double d3 = d2 - d;
        if (d3 < -400.0 || d2 < -1.7976931348623156E306) {
            return d;
        }
        return d + StrictMath.log1p(-Math.exp(d3));
    }
}

