/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.ComplexArray;

public class FastFourierTransform {
    public static void fft(double[] dArray, int n, boolean bl) {
        int n2;
        int n3;
        double d = bl ? Math.PI * 2 : Math.PI * -2;
        int n4 = n << 1;
        int n5 = 1;
        for (n3 = 1; n3 < n4; n3 += 2) {
            if (n5 > n3) {
                FastFourierTransform.swap(dArray, n5 - 1, n3 - 1);
                FastFourierTransform.swap(dArray, n5, n3);
            }
            for (n2 = n; n2 >= 2 && n5 > n2; n5 -= n2, n2 >>= 1) {
            }
            n5 += n2;
        }
        int n6 = 2;
        while (n4 > n6) {
            int n7 = n6 << 1;
            double d2 = d / (double)n6;
            double d3 = Math.sin(0.5 * d2);
            double d4 = -2.0 * d3 * d3;
            double d5 = Math.sin(d2);
            double d6 = 1.0;
            double d7 = 0.0;
            for (n2 = 1; n2 < n6; n2 += 2) {
                for (n3 = n2; n3 <= n4; n3 += n7) {
                    n5 = n3 + n6;
                    double d8 = d6 * dArray[n5 - 1] - d7 * dArray[n5];
                    double d9 = d6 * dArray[n5] + d7 * dArray[n5 - 1];
                    dArray[n5 - 1] = dArray[n3 - 1] - d8;
                    dArray[n5] = dArray[n3] - d9;
                    int n8 = n3 - 1;
                    dArray[n8] = dArray[n8] + d8;
                    int n9 = n3;
                    dArray[n9] = dArray[n9] + d9;
                }
                d3 = d6;
                d6 += d6 * d4 - d7 * d5;
                d7 += d7 * d4 + d3 * d5;
            }
            n6 = n7;
        }
    }

    public static void fft(ComplexArray complexArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        double[] dArray = complexArray.real;
        double[] dArray2 = complexArray.complex;
        double d = bl ? Math.PI * 2 : Math.PI * -2;
        int n5 = complexArray.length << 1;
        int n6 = 1;
        for (n4 = 1; n4 < n5; n4 += 2) {
            if (n6 > n4) {
                n3 = n4 >> 1;
                n2 = n6 >> 1;
                FastFourierTransform.swap(dArray, n2, n3);
                FastFourierTransform.swap(dArray2, n2, n3);
            }
            for (n = complexArray.length; n >= 2 && n6 > n; n6 -= n, n >>= 1) {
            }
            n6 += n;
        }
        int n7 = 2;
        while (n5 > n7) {
            int n8 = n7 << 1;
            double d2 = d / (double)n7;
            double d3 = Math.sin(0.5 * d2);
            double d4 = -2.0 * d3 * d3;
            double d5 = Math.sin(d2);
            double d6 = 1.0;
            double d7 = 0.0;
            for (n = 1; n < n7; n += 2) {
                for (n4 = n; n4 <= n5; n4 += n8) {
                    n6 = n4 + n7;
                    n3 = n4 >> 1;
                    n2 = n6 >> 1;
                    double d8 = d6 * dArray[n2] - d7 * dArray2[n2];
                    double d9 = d6 * dArray2[n2] + d7 * dArray[n2];
                    dArray[n2] = dArray[n3] - d8;
                    dArray2[n2] = dArray2[n3] - d9;
                    int n9 = n3;
                    dArray[n9] = dArray[n9] + d8;
                    int n10 = n3;
                    dArray2[n10] = dArray2[n10] + d9;
                }
                d3 = d6;
                d6 += d6 * d4 - d7 * d5;
                d7 += d7 * d4 + d3 * d5;
            }
            n7 = n8;
        }
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }
}

