/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.markovchain.Acceptor;
import dr.inference.mcmc.MCMCCriterion;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class IndependentEvaluationOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "independentEvaluationOperator";
    public static final String OPERATORS = "operators";
    private final CompoundLikelihood likelihoods;
    private final List<MCMCOperator> operators;
    private final Acceptor acceptor = new MCMCCriterion();
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(CompoundLikelihood.class), new ElementRule("operators", new XMLSyntaxRule[]{new ElementRule(MCMCOperator.class, 1, Integer.MAX_VALUE)}, "Operators to control")};

        @Override
        public String getParserName() {
            return IndependentEvaluationOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            CompoundLikelihood compoundLikelihood = (CompoundLikelihood)xMLObject.getChild(CompoundLikelihood.class);
            ArrayList<MCMCOperator> arrayList = new ArrayList<MCMCOperator>();
            XMLObject xMLObject2 = xMLObject.getChild(IndependentEvaluationOperator.OPERATORS);
            for (MCMCOperator mCMCOperator : xMLObject2.getAllChildren(MCMCOperator.class)) {
                arrayList.add(mCMCOperator);
            }
            if (compoundLikelihood.getLikelihoodCount() != arrayList.size()) {
                throw new XMLParseException("The number of likelihoods does not match the number of operators");
            }
            return new IndependentEvaluationOperator(compoundLikelihood, arrayList, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a sampler, disguised as a Gibbs operator, that controls operators on independent likelihoods.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public IndependentEvaluationOperator(CompoundLikelihood compoundLikelihood, List<MCMCOperator> list, double d) {
        super(d);
        this.likelihoods = compoundLikelihood;
        this.operators = list;
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "IndependentEvaluationOperator(" + this.likelihoods.getId() + ")";
    }

    public int getStepCount() {
        return this.likelihoods.getLikelihoodCount();
    }

    @Override
    public double doOperation() {
        double[] dArray = new double[this.likelihoods.getLikelihoodCount()];
        double[] dArray2 = new double[this.likelihoods.getLikelihoodCount()];
        int n = 0;
        for (Likelihood object : this.likelihoods.getLikelihoods()) {
            dArray[n] = object.getLogLikelihood();
            ++n;
        }
        n = 0;
        for (MCMCOperator mCMCOperator : this.operators) {
            dArray2[n] = mCMCOperator.operate();
            ++n;
        }
        this.likelihoods.getLogLikelihood();
        Object object = new double[]{0.0};
        n = 0;
        for (Likelihood likelihood : this.likelihoods.getLikelihoods()) {
            MCMCOperator mCMCOperator = this.operators.get(n);
            double d = likelihood.getLogLikelihood();
            boolean bl = this.acceptor.accept(dArray[n], d, dArray2[n], (double[])object);
            if (bl) {
                mCMCOperator.accept(d - dArray[n]);
            } else {
                mCMCOperator.reject();
                likelihood.getModel().restoreModelState();
            }
            if (mCMCOperator instanceof AdaptableMCMCOperator) {
                this.adaptAcceptanceProbability((AdaptableMCMCOperator)mCMCOperator, (double)object[0]);
            }
            ++n;
        }
        return 0.0;
    }

    public void adaptAcceptanceProbability(AdaptableMCMCOperator adaptableMCMCOperator, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl;
        boolean bl2 = bl = adaptableMCMCOperator.getMode() == AdaptationMode.ADAPTATION_ON || adaptableMCMCOperator.getMode() != AdaptationMode.ADAPTATION_OFF;
        if (bl && (d6 = (d5 = adaptableMCMCOperator.getAdaptableParameter()) + 1.0 / (d4 = OperatorSchedule.DEFAULT_TRANSFORM.transform(adaptableMCMCOperator.getAdaptationCount() + 2L)) * ((d3 = Math.exp(d)) - (d2 = adaptableMCMCOperator.getTargetAcceptanceProbability()))) > -1.7976931348623157E308 && d6 < Double.MAX_VALUE) {
            adaptableMCMCOperator.setAdaptableParameter(d6);
        }
    }

    private boolean isAdaptable(AdaptableMCMCOperator adaptableMCMCOperator) {
        return adaptableMCMCOperator.getMode() == AdaptationMode.ADAPTATION_ON || adaptableMCMCOperator.getMode() != AdaptationMode.ADAPTATION_OFF;
    }
}

