/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.stats.DiscreteStatistics;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DesignMatrix
extends MatrixParameter {
    public static final String DESIGN_MATRIX = "designMatrix";
    public static final String ADD_INTERCEPT = "addIntercept";
    public static final String FORM = "form";
    public static final String ROW_DIMENSION = "rowDimension";
    public static final String COL_DIMENSION = "colDimension";
    public static final String CHECK_IDENTIFABILITY = "checkIdentifiability";
    public static final String STANDARDIZE = "standardize";
    private static final String IGNORE_STANDARDIZATION_COLUMN = "ignoreStandardizationColumn";
    public static final String DYNAMIC_STANDARDIZATION = "dynamicStandardization";
    public static final String INTERCEPT = "intercept";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("addIntercept", true), AttributeRule.newBooleanRule("checkIdentifiability", true), new ElementRule(Parameter.class, 0, Integer.MAX_VALUE), AttributeRule.newStringRule("form", true), AttributeRule.newIntegerRule("colDimension", true), AttributeRule.newIntegerRule("rowDimension", true), AttributeRule.newBooleanRule("standardize", true)};

        @Override
        public String getParserName() {
            return DesignMatrix.DESIGN_MATRIX;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            Object object;
            boolean bl = xMLObject.getAttribute(DesignMatrix.DYNAMIC_STANDARDIZATION, false);
            String string = xMLObject.hasId() ? xMLObject.getId() : DesignMatrix.DESIGN_MATRIX;
            DesignMatrix designMatrix = new DesignMatrix(string, bl);
            boolean bl2 = xMLObject.getAttribute(DesignMatrix.ADD_INTERCEPT, false);
            boolean bl3 = xMLObject.getAttribute(DesignMatrix.STANDARDIZE, false);
            boolean bl4 = xMLObject.getAttribute("centerOnly", false);
            int n2 = 0;
            if (xMLObject.hasAttribute(DesignMatrix.FORM)) {
                object = xMLObject.getStringAttribute(DesignMatrix.FORM);
                if (((String)object).compareTo("J") != 0) throw new XMLParseException("Unknown designMatrix form.");
                int n3 = xMLObject.getAttribute(DesignMatrix.ROW_DIMENSION, 1);
                int n4 = xMLObject.getAttribute(DesignMatrix.COL_DIMENSION, 1);
                for (n = 0; n < n4; ++n) {
                    Parameter.Default default_ = new Parameter.Default(n3);
                    designMatrix.addParameter(default_);
                }
            } else {
                for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                    Parameter parameter = (Parameter)xMLObject.getChild(i);
                    designMatrix.addParameter(parameter);
                    if (i == 0) {
                        n2 = parameter.getDimension();
                        continue;
                    }
                    if (n2 == parameter.getDimension()) continue;
                    throw new XMLParseException("Parameter " + (i + 1) + " has dimension " + parameter.getDimension() + " and not " + n2 + ". All parameters must have the same dimension to construct a rectangular design matrix");
                }
            }
            if (bl2) {
                object = new Parameter.Default(n2);
                object.setId(DesignMatrix.INTERCEPT);
                designMatrix.addParameter((Parameter)object);
            }
            if (!bl3) return designMatrix;
            for (int i = 0; i < designMatrix.getColumnDimension(); ++i) {
                Parameter parameter = designMatrix.getParameter(i);
                if (parameter.getId().toLowerCase().indexOf(DesignMatrix.INTERCEPT) >= 0) {
                    Logger.getLogger("dr.inference.model").info("\nNot standardizing column '" + parameter.getId() + "' in design matrix '" + designMatrix.getId() + "'\n");
                    continue;
                }
                double[] dArray = parameter.getParameterValues();
                DesignMatrix.standardize(dArray, !bl4);
                for (n = 0; n < dArray.length; ++n) {
                    parameter.setParameterValueQuietly(n, dArray[n]);
                }
                parameter.setParameterValueNotifyChangedAll(0, parameter.getParameterValue(0));
            }
            return designMatrix;
        }

        @Override
        public String getParserDescription() {
            return "A matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return DesignMatrix.class;
        }
    };
    private final boolean dynamicStandardization;
    private boolean standardizationKnown = false;
    private double[] standardizationMean = null;
    private double[] standardizationStDev = null;
    private double[] storedStandardizationMean = null;
    private double[] storedStandardizationStDev = null;

    public DesignMatrix(String string, boolean bl) {
        super(string);
        this.dynamicStandardization = bl;
        this.init();
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.variableChangedEvent(variable, n, changeType);
        this.standardizationKnown = false;
    }

    protected double getRawParameterValue(int n, int n2) {
        return super.getParameterValue(n, n2);
    }

    @Override
    public double getParameterValue(int n, int n2) {
        double d = this.getRawParameterValue(n, n2);
        if (this.dynamicStandardization) {
            if (!this.standardizationKnown) {
                this.computeStandarization();
                this.standardizationKnown = true;
            }
            d = (d - this.standardizationMean[n2]) / this.standardizationStDev[n2];
        }
        return d;
    }

    @Override
    public void addParameter(Parameter parameter) {
        super.addParameter(parameter);
        this.clearCache();
    }

    @Override
    public void removeParameter(Parameter parameter) {
        super.removeParameter(parameter);
        this.clearCache();
    }

    private void clearCache() {
        this.standardizationMean = null;
        this.standardizationStDev = null;
        this.storedStandardizationMean = null;
        this.storedStandardizationStDev = null;
    }

    private void computeStandarization() {
        if (this.standardizationMean == null) {
            this.standardizationMean = new double[this.getColumnDimension()];
        }
        if (this.standardizationStDev == null) {
            this.standardizationStDev = new double[this.getColumnDimension()];
        }
        for (int i = 0; i < this.getColumnDimension(); ++i) {
            if (this.getParameter(i).getId().toLowerCase().indexOf(INTERCEPT) >= 0) {
                this.standardizationMean[i] = 0.0;
                this.standardizationStDev[i] = 1.0;
                continue;
            }
            double[] dArray = this.getParameter(i).getParameterValues();
            this.standardizationMean[i] = DiscreteStatistics.mean(dArray);
            this.standardizationStDev[i] = Math.sqrt(DiscreteStatistics.variance(dArray, this.standardizationMean[i]));
        }
    }

    @Override
    protected void storeValues() {
        super.storeValues();
        if (this.dynamicStandardization) {
            if (this.storedStandardizationMean == null) {
                this.storedStandardizationMean = new double[this.standardizationMean.length];
            }
            System.arraycopy(this.standardizationMean, 0, this.storedStandardizationMean, 0, this.standardizationMean.length);
            if (this.storedStandardizationStDev == null) {
                this.storedStandardizationStDev = new double[this.standardizationStDev.length];
            }
            System.arraycopy(this.standardizationStDev, 0, this.storedStandardizationStDev, 0, this.standardizationStDev.length);
        }
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        if (this.dynamicStandardization) {
            double[] dArray = this.standardizationMean;
            this.standardizationMean = this.storedStandardizationMean;
            this.storedStandardizationMean = dArray;
            dArray = this.standardizationStDev;
            this.standardizationStDev = this.storedStandardizationStDev;
            this.storedStandardizationStDev = dArray;
        }
    }

    public DesignMatrix(String string, Parameter[] parameterArray, boolean bl) {
        super(string, parameterArray);
        this.dynamicStandardization = bl;
        this.init();
    }

    private void init() {
        this.standardizationKnown = false;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    public static void standardize(double[] dArray, boolean bl) {
        double d = DiscreteStatistics.mean(dArray);
        double d2 = bl ? Math.sqrt(DiscreteStatistics.variance(dArray, d)) : 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (dArray[i] - d) / d2;
        }
    }
}

