/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hawkes;

import dr.inference.hawkes.HawkesCore;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public interface HawkesRateProvider {
    public void setRandomRates(HawkesCore var1);

    public Parameter getParameter();

    public static class Default
    extends AbstractModel
    implements HawkesRateProvider {
        Parameter rate;

        Default(Parameter parameter) {
            super("HawkesRateProvider$Default");
            this.rate = parameter;
            this.addVariable(parameter);
        }

        @Override
        public void setRandomRates(HawkesCore hawkesCore) {
            hawkesCore.setRandomRates(this.rate.getParameterValues());
        }

        @Override
        public Parameter getParameter() {
            return this.rate;
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }
    }

    public static class None
    implements HawkesRateProvider {
        @Override
        public void setRandomRates(HawkesCore hawkesCore) {
        }

        @Override
        public Parameter getParameter() {
            throw new RuntimeException("No rate parameter in the 'None' case of Hawkes");
        }
    }
}

