/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.LinkageConstraints;
import dr.evolution.LinkedGroup;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class LinkageConstraintsParser
extends AbstractXMLObjectParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(LinkedGroup.class, 1, Integer.MAX_VALUE)};

    @Override
    public String getParserDescription() {
        return "Data representing metagenome reads that are linked by mate-pair, strobe, or other information";
    }

    @Override
    public Class getReturnType() {
        return LinkageConstraints.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        ArrayList<LinkedGroup> arrayList = new ArrayList<LinkedGroup>();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (!(object instanceof LinkedGroup)) continue;
            arrayList.add((LinkedGroup)object);
        }
        LinkageConstraints linkageConstraints = new LinkageConstraints(arrayList);
        return linkageConstraints;
    }

    @Override
    public String getParserName() {
        return "LinkageConstraints";
    }
}

