/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.PartiallyMissingInformation;
import dr.evomodel.treedatalikelihood.preorder.ConditionalVarianceAndTransform2;
import dr.evomodel.treedatalikelihood.preorder.TipFullConditionalDistributionDelegate;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;

public abstract class AbstractValuesViaFullConditionalDelegate
extends TipFullConditionalDistributionDelegate {
    private final PartiallyMissingInformation missingInformation;
    private static Boolean DEBUG = false;

    @Override
    protected boolean isLoggable() {
        return false;
    }

    public AbstractValuesViaFullConditionalDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, tree, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
        this.missingInformation = new PartiallyMissingInformation(tree, continuousTraitPartialsProvider);
    }

    @Override
    protected double[] getTraitForNode(NodeRef nodeRef) {
        assert (this.simulationProcess != null);
        assert (nodeRef != null);
        int n = this.likelihoodDelegate.getActiveNodeIndex(nodeRef.getNumber());
        if (nodeRef.getNumber() >= this.tree.getExternalNodeCount()) {
            return new double[0];
        }
        double[] dArray = null;
        this.likelihoodDelegate.getPostOrderPartial(nodeRef.getNumber(), this.partialNodeBuffer);
        double[] dArray2 = new double[this.dimTrait * this.numTraits];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.numTraits; ++i) {
            if (this.missingInformation.isPartiallyMissing(nodeRef.getNumber(), i)) {
                if (dArray == null) {
                    dArray = new double[this.dimPartial * this.numTraits];
                    this.simulationProcess.cacheSimulatedTraits(nodeRef);
                    this.cdi.getPreOrderPartial(n, dArray);
                }
                if (DEBUG.booleanValue()) {
                    System.err.println("Missing tip = " + nodeRef.getNumber() + " (" + n + "), trait = " + i);
                }
                WrappedVector.Raw raw = new WrappedVector.Raw(dArray, n2, this.dimTrait);
                DenseMatrix64F denseMatrix64F = MissingOps.wrap(dArray, n2 + this.dimTrait + this.dimTrait * this.dimTrait, this.dimTrait, this.dimTrait);
                WrappedVector.Raw raw2 = new WrappedVector.Raw(this.partialNodeBuffer, n2, this.dimTrait);
                if (DEBUG.booleanValue()) {
                    System.err.println("post: " + raw2);
                    System.err.println("pre : " + raw);
                    System.err.println("V: " + denseMatrix64F);
                }
                if (!this.missingInformation.isCompletelyMissing(nodeRef.getNumber(), i)) {
                    PartiallyMissingInformation.HashedIntArray hashedIntArray = this.missingInformation.getMissingIndices(nodeRef.getNumber(), i);
                    int[] nArray = hashedIntArray.getArray();
                    int[] nArray2 = hashedIntArray.getComplement();
                    ConditionalVarianceAndTransform2 conditionalVarianceAndTransform2 = new ConditionalVarianceAndTransform2(denseMatrix64F, nArray, nArray2);
                    WrappedVector wrappedVector = conditionalVarianceAndTransform2.getConditionalMean(this.partialNodeBuffer, n2, dArray, n2);
                    this.computeValueWithMissing(wrappedVector, conditionalVarianceAndTransform2.getConditionalCholesky(), new WrappedVector.Indexed(dArray2, n3, nArray), conditionalVarianceAndTransform2.getTemporaryStorage());
                    if (DEBUG.booleanValue()) {
                        System.err.println("cM: " + wrappedVector);
                        System.err.println("CV: " + conditionalVarianceAndTransform2.getConditionalVariance());
                        System.err.println("value: " + new WrappedVector.Raw(dArray2, n3, this.dimTrait));
                    }
                }
            } else {
                this.computeValueWithNoMissing(this.partialNodeBuffer, n2, dArray2, n3, this.dimTrait);
            }
            n2 += this.dimPartial;
            n3 += this.dimTrait;
        }
        return dArray2;
    }

    protected abstract void computeValueWithNoMissing(double[] var1, int var2, double[] var3, int var4, int var5);

    protected abstract void computeValueWithMissing(WrappedVector var1, double[][] var2, WrappedVector var3, double[] var4);
}

