/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.GlmSubstitutionModel;
import dr.inference.distribution.GeneralizedLinearModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlmCovariateImportance
implements Loggable,
Reportable {
    private final Likelihood likelihood;
    private final GeneralizedLinearModel glm;
    private final int dim;
    private final List<Parameter> covariates;
    private double currentLogLikelihood = Double.NaN;
    private LogColumn[] columns;
    private final Map<Integer, IndexPair> parameterMap;

    public GlmCovariateImportance(Likelihood likelihood, GlmSubstitutionModel glmSubstitutionModel) {
        this.likelihood = likelihood;
        this.glm = glmSubstitutionModel.getGeneralizedLinearModel();
        this.covariates = new ArrayList<Parameter>();
        this.parameterMap = new HashMap<Integer, IndexPair>();
        int n = 0;
        for (int i = 0; i < this.glm.getNumberOfFixedEffects(); ++i) {
            DesignMatrix designMatrix = this.glm.getDesignMatrix(i);
            int n2 = designMatrix.getColumnDimension();
            for (int j = 0; j < n2; ++j) {
                this.covariates.add(designMatrix.getParameter(j));
                this.parameterMap.put(n + j, new IndexPair(i, j));
            }
            n += n2;
        }
        this.dim = n;
    }

    private double getDeviance(int n) {
        double d;
        if (n == 0) {
            if (!Double.isNaN(this.currentLogLikelihood)) {
                throw new IllegalStateException("GlmCovariateImportance computation is already in-process");
            }
            this.currentLogLikelihood = this.likelihood.getLogLikelihood();
        } else if (Double.isNaN(this.currentLogLikelihood)) {
            throw new IllegalStateException("GlmCovariateImportance computation is already in-process");
        }
        boolean bl = true;
        if (n != this.dim) {
            IndexPair indexPair = this.parameterMap.get(n);
            double d2 = this.glm.getFixedEffect(indexPair.fixedEffectIndex).getParameterValue(indexPair.parameterValueIndex);
            if (this.glm.getFixedEffectIndicator(indexPair.fixedEffectIndex) != null) {
                d2 *= this.glm.getFixedEffectIndicator(indexPair.fixedEffectIndex).getParameterValue(indexPair.parameterValueIndex);
            }
            if (d2 == 0.0) {
                bl = false;
            }
        }
        if (bl) {
            this.glm.storeModelState();
            this.permute(n);
            d = this.currentLogLikelihood - this.likelihood.getLogLikelihood();
            this.glm.restoreModelState();
            this.glm.fireModelChanged();
        } else {
            d = 0.0;
        }
        if (n == this.dim) {
            this.currentLogLikelihood = Double.NaN;
        }
        return d;
    }

    private void permute(int n) {
        if (n != this.dim) {
            this.permuteOneImpl(n);
        } else {
            for (int i = 0; i < this.dim; ++i) {
                this.permuteOneImpl(i);
            }
        }
    }

    private void permuteOneImpl(int n) {
        Parameter parameter = this.covariates.get(n);
        double[] dArray = parameter.getParameterValues();
        this.shuffle(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        parameter.fireParameterChangedEvent();
    }

    private void shuffle(double[] dArray) {
        for (int i = dArray.length - 1; i > 0; --i) {
            int n = MathUtils.nextInt(i + 1);
            double d = dArray[n];
            dArray[n] = dArray[i];
            dArray[i] = d;
        }
    }

    @Override
    public LogColumn[] getColumns() {
        if (this.columns == null) {
            this.columns = new LogColumn[this.dim + 2];
            this.columns[0] = new NumberColumn("logLikelihood"){

                @Override
                public double getDoubleValue() {
                    return GlmCovariateImportance.this.likelihood.getLogLikelihood();
                }
            };
            for (int i = 0; i < this.dim + 1; ++i) {
                final int n = i;
                String string = "deviance" + (n < this.dim ? Integer.valueOf(n + 1) : "All");
                this.columns[i + 1] = new NumberColumn(string){

                    @Override
                    public double getDoubleValue() {
                        return GlmCovariateImportance.this.getDeviance(n);
                    }
                };
            }
        }
        return this.columns;
    }

    @Override
    public String getReport() {
        LogColumn[] logColumnArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (LogColumn logColumn : logColumnArray = this.getColumns()) {
            String string = logColumn.getLabel();
            String string2 = logColumn.getFormatted();
            stringBuilder.append(string).append(": ").append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    static class IndexPair {
        int fixedEffectIndex;
        int parameterValueIndex;

        IndexPair(int n, int n2) {
            this.fixedEffectIndex = n;
            this.parameterValueIndex = n2;
        }
    }
}

