/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.evomodel.branchmodel.lineagespecific.DirichletProcessPrior;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import org.apache.commons.math.MathException;

public class DirichletProcessOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private static final boolean DEBUG = false;
    private DirichletProcessPrior dpp;
    private int realizationCount;
    private int uniqueRealizationCount;
    private double intensity;
    private int mhSteps;
    private Parameter categoriesParameter;
    private CountableRealizationsParameter allParameters;
    private Parameter uniqueParameters;
    private CompoundLikelihood likelihood;

    public DirichletProcessOperator(DirichletProcessPrior dirichletProcessPrior, Parameter parameter, Parameter parameter2, CountableRealizationsParameter countableRealizationsParameter, Likelihood likelihood, int n, double d) {
        this.dpp = dirichletProcessPrior;
        this.intensity = dirichletProcessPrior.getGamma();
        this.uniqueRealizationCount = dirichletProcessPrior.getCategoryCount();
        this.realizationCount = parameter.getDimension();
        this.categoriesParameter = parameter;
        this.allParameters = countableRealizationsParameter;
        this.uniqueParameters = parameter2;
        this.likelihood = (CompoundLikelihood)likelihood;
        this.mhSteps = n;
        this.setWeight(d);
    }

    @Override
    public Parameter getParameter() {
        return this.categoriesParameter;
    }

    public Variable getVariable() {
        return this.categoriesParameter;
    }

    @Override
    public double doOperation() {
        try {
            this.doOp();
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        return 0.0;
    }

    private void doOp() throws MathException {
        for (int i = 0; i < this.realizationCount; ++i) {
            double d;
            double d2;
            int n;
            int n2;
            int[] nArray = new int[this.uniqueRealizationCount];
            for (int j = 0; j < this.realizationCount; ++j) {
                if (j == i) continue;
                int n3 = n2 = (int)this.categoriesParameter.getParameterValue(j);
                nArray[n3] = nArray[n3] + 1;
            }
            double[] dArray = new double[this.uniqueRealizationCount];
            n2 = 0;
            int n4 = -1;
            for (int j = 0; j < this.uniqueRealizationCount; ++j) {
                if (nArray[j] > 0) {
                    nArray[n2] = nArray[j];
                    dArray[n2++] = this.dpp.getUniqueParameter(j).getParameterValue(0);
                    continue;
                }
                n4 = j;
            }
            double[] dArray2 = new double[this.realizationCount];
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = this.dpp.baseModel.nextRandom()[0];
            }
            if (n4 > -1) {
                dArray2[0] = this.uniqueParameters.getParameterValue(n4);
            }
            double[] dArray3 = new double[this.uniqueRealizationCount];
            for (n = 0; n < n2; ++n) {
                dArray3[n] = Math.log((double)nArray[n] / ((double)(this.realizationCount - 1) + this.intensity));
                d2 = this.allParameters.getParameterValue(i);
                d = dArray[n];
                this.allParameters.setParameterValue(i, d);
                this.likelihood.makeDirty();
                dArray3[n] = dArray3[n] + this.likelihood.getLikelihood(i).getLogLikelihood();
                this.allParameters.setParameterValue(i, d2);
                this.likelihood.makeDirty();
            }
            while (n < dArray3.length) {
                dArray3[n] = Math.log(this.intensity / ((double)(this.realizationCount - 1) + this.intensity));
                d2 = this.allParameters.getParameterValue(i);
                d = dArray2[n - n2];
                this.allParameters.setParameterValue(i, d);
                this.likelihood.makeDirty();
                dArray3[n] = dArray3[n] + this.likelihood.getLikelihood(i).getLogLikelihood();
                this.allParameters.setParameterValue(i, d2);
                this.likelihood.makeDirty();
                ++n;
            }
            d2 = dArray3[0];
            for (n = 1; n < this.uniqueRealizationCount; ++n) {
                if (!(d2 > dArray3[n])) continue;
                d2 = dArray3[n];
            }
            double[] dArray4 = new double[this.uniqueRealizationCount];
            for (n = 0; n < dArray4.length; ++n) {
                dArray4[n] = Math.exp(dArray3[n] - d2);
            }
            int n5 = MathUtils.randomChoicePDF(dArray4);
            this.categoriesParameter.setParameterValue(i, n5);
        }
    }

    private void doOperate() throws MathException {
        for (int i = 0; i < this.realizationCount; ++i) {
            int n;
            int n2;
            int[] nArray = new int[this.uniqueRealizationCount];
            for (int j = 0; j < this.realizationCount; ++j) {
                if (j == i) continue;
                int n3 = n2 = (int)this.categoriesParameter.getParameterValue(j);
                nArray[n3] = nArray[n3] + 1;
            }
            Likelihood likelihood = this.likelihood.getLikelihood(i);
            n2 = (int)this.categoriesParameter.getParameterValue(i);
            double d = this.uniqueParameters.getParameterValue(n2);
            double[] dArray = new double[this.uniqueRealizationCount];
            for (n = 0; n < this.uniqueRealizationCount; ++n) {
                double d2;
                double d3;
                double d4 = 0.0;
                if (nArray[n] == 0) {
                    d3 = this.dpp.baseModel.nextRandom()[0];
                    this.uniqueParameters.setParameterValue(n2, d3);
                    d2 = likelihood.getLogLikelihood();
                    this.uniqueParameters.setParameterValue(n2, d);
                    d4 = Math.log(this.intensity / ((double)(this.realizationCount - 1) + this.intensity)) + d2;
                } else {
                    d3 = this.dpp.getUniqueParameter(n).getParameterValue(0);
                    this.uniqueParameters.setParameterValue(n2, d3);
                    d2 = likelihood.getLogLikelihood();
                    this.uniqueParameters.setParameterValue(n2, d);
                    d4 = Math.log(nArray[n]) / ((double)(this.realizationCount - 1) + this.intensity) + d2;
                }
                dArray[n] = d4;
            }
            DirichletProcessOperator.exponentiate(dArray);
            n = MathUtils.randomChoicePDF(dArray);
            this.categoriesParameter.setParameterValue(i, n);
        }
    }

    public static void exponentiate(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
    }

    @Override
    public String getOperatorName() {
        return "dpOperator";
    }
}

