/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.SequenceList;

public interface Alignment
extends SequenceList,
SiteList {
    public void setDataType(DataType var1);

    public String getAlignedSequenceString(int var1);

    public String getUnalignedSequenceString(int var1);

    public static abstract class Abstract
    implements Alignment {
        protected String id = null;

        @Override
        public int getPatternCount() {
            return this.getSiteCount();
        }

        public int getInvariantCount() {
            throw new RuntimeException("Not implemented yet");
        }

        @Override
        public int getStateCount() {
            return this.getDataType().getStateCount();
        }

        @Override
        public int getPatternLength() {
            return this.getSequenceCount();
        }

        @Override
        public int[] getPattern(int n) {
            return this.getSitePattern(n);
        }

        @Override
        public double[][] getUncertainPattern(int n) {
            return this.getUncertainSitePattern(n);
        }

        @Override
        public int getPatternState(int n, int n2) {
            return this.getState(n, n2);
        }

        @Override
        public double[] getUncertainPatternState(int n, int n2) {
            return this.getUncertainPatternState(n, n2);
        }

        @Override
        public double getPatternWeight(int n) {
            return 1.0;
        }

        @Override
        public double[] getPatternWeights() {
            int n = this.getSiteCount();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0;
            }
            return dArray;
        }

        @Override
        public double[] getStateFrequencies() {
            return PatternList.Utils.empiricalStateFrequencies(this);
        }

        @Override
        public boolean areUnique() {
            return false;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }
    }
}

