% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{chi_square_goodness_of_fit_from_input_all_param_MRMC}
\alias{chi_square_goodness_of_fit_from_input_all_param_MRMC}
\title{Chi square in the case of MRMC at a given dataset and a given parameter.}
\usage{
chi_square_goodness_of_fit_from_input_all_param_MRMC(ppp, dl, dataList,
  summary = TRUE)
}
\arguments{
\item{ppp}{An array of \code{[C,M,Q]}, representing hit rate,
where \code{C,M,Q} denotes the number of confidences, modalities,
 readers, respectively.}

\item{dl}{An vector of length \code{C M Q} representing
false alarm rate,
where \code{C,M,Q} denotes the number of
 confidences, modalities, readers, respectively.}

\item{dataList}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.



 For the single reader and a single modality data, the \code{dataList} is the following forms:

\code{ dataList.Example <- list(       }

\code{            h = c(41,22,14,8,1),   }

\code{            f = c(1,2,5,11,13),    }

\code{            NL = 124,     }

\code{            NI = 63,    }

\code{            C = 5)         }

And using this object \code{dataList.Example}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dataList.Example)}.






To make this \R object \code{dataList}, this package provides three functions:
please use one of the following codes to obtain an \R object representing FROC data:


\describe{
\item{  \code{ \link{convertFromJafroc}()}           }{ If  data is a           \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()} }{ Enter TP and FP data    \emph{\strong{by table   }}.            }
\item{  \code{ \link{create_dataset}()}              }{ Enter TP and FP data by \emph{\strong{interactive}} manner.     }
}

This package includes FROC datasets.
Before running the function, we can confirm dataset is correctly formulated by using the function \strong{\code{ \link{viewdata}}}.


----------------------------------------------------------------------------------------


  \strong{A Single reader and a single modality (SRSC) case.}


----------------------------------------------------------------------------------------

In a single reader and a single modality case (srsc), it should be a list which includes  \code{f, h, NL, NI, C}.
This list contains the following numeric vectors \code{f, h} and numeric \code{NL, NI, C} :
\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of False Alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ data Format:}}

 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
 \emph{probably} present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
 equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
 subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
 \emph{very} subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
 }

---------------------------------------------------------------------------------------------------



*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, all confidence level means \emph{present} (\emph{diseased, lesion}) case only, no confidence level indicating absent.. Since each reader marks their suspicious location only and it generate the hits and false alarms, \emph{thus} his confidence level representing that lesion is \emph{present}.
In the absent case, reader dose not mark any locations and hence, the absent confidence level does not relate this dataset. So, if reader think it is no lesion, then in such case confidence level is not needed.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your data and the program's generating new confidence  level vector by
a table which can be displayed by the function \code{\link{viewdata}()}.









---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


For  multiple readers and multiple modalities case, i.e., MRMC case,
to apply the function \code{fit_Bayesian_FROC()}, an \R list object representing FROC data
must have components \code{m,q,c,h,f,NL,C,M,Q}:
\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}} vector.}
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarm}} vector.}
\item{ \code{NL }  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}



The detail of these dataset, please see the example datasets ( the section \strong{See Also} in the below) in this package.



Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{\link{viewdata}()}.


\strong{\emph{ Example data: }}

 \emph{ Multiple readers and multiple modalities case, i.e., MRMC case }




---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ Reader ID} \tab   \strong{Mortality }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 5 \tab  1\tab 15\cr
  1 \tab 2 \tab 4  \tab 3\tab 14\cr
  1 \tab 3 \tab 3  \tab 5\tab 5\cr
  1 \tab 1 \tab 2  \tab 5\tab 3\cr
  1 \tab 2 \tab 1  \tab 9\tab 4\cr
  1 \tab 3 \tab 5  \tab 1\tab 14\cr
  1 \tab 1 \tab 4  \tab 2\tab 13\cr
  1 \tab 2 \tab 3  \tab 2\tab 5\cr
  1 \tab 3 \tab 2 \tab 5\tab 3\cr
  2 \tab 1 \tab 1 \tab  6\tab 4\cr
  2 \tab 2 \tab 5  \tab 1\tab 14\cr
  2 \tab 3 \tab 4  \tab 1\tab 4\cr
  2 \tab 1 \tab 3  \tab 1\tab 1\cr
  2 \tab 2 \tab 2  \tab 2\tab 2\cr
  2 \tab 3 \tab 1  \tab 3\tab 2\cr
  2 \tab 1 \tab 5  \tab 1\tab 13\cr
  2 \tab 2 \tab 4 \tab 2\tab 4\cr
  2 \tab 3 \tab 3  \tab 1\tab 2\cr }
---------------------------------------------------------------------------------------------------




*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
A list, contains  \eqn{\chi^2(Data|\theta)},
 where \eqn{Data} and \eqn{\theta} are specified by user.
}
\description{
Given parameter and data, the chi square is calculated.
}
\examples{


\donttest{
#----------------------------------------------------------------------------------------
#  0)
#----------------------------------------------------------------------------------------

#        Chi square depend on data and model parameter, thus what we have to do is:
#        prepare data and parameter

                # In the follwoing, we use data named ddd as a dataset,
                # and use parameter from posterior mean estimates

#  So, we calculate chi square at using data ddd
#  and parameter EAP estimated using ddd.



      fit <- fit_Bayesian_FROC(  dataList = ddd )


#----------------------------------------------------------------------------------------
#  1)  prepare hit rate and false alarm rate
#----------------------------------------------------------------------------------------


         e <-extract_estimates_MRMC(fit);
         dl <- e$dl.EAP;
         ppp <- e$ppp.EAP;


#----------------------------------------------------------------------------------------
# 2)  Calculate chi square using above hit rate and false alarm rate and data named ddd
#----------------------------------------------------------------------------------------

         chi_square_goodness_of_fit_from_input_all_param_MRMC(ppp,dl,ddd)

}# donttest



}
\author{
Issei Tsunoda
}
