% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFROC.R
\name{ggplotFROC.EAP}
\alias{ggplotFROC.EAP}
\title{Draw FROC curves by two parameters a and b}
\usage{
ggplotFROC.EAP(a, b, mesh.for.drawing.curve = 10000, upper_x = 1,
  upper_y = 1, lower_y = 0, dataList, StanS4class)
}
\arguments{
\item{a}{See paper for definition.}

\item{b}{See paper for definition.}

\item{mesh.for.drawing.curve}{This is a number of points using draw the curves, default =10000}

\item{upper_x}{The frame size of drawing picture.}

\item{upper_y}{The frame size of drawing picture.}

\item{lower_y}{The frame size of drawing picture.}

\item{dataList}{This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.

To make this R object \code{dataList}, please use one of the following codes:

  \code{ \link{convertFromJafroc}}, \code{ \link{dataset_creator_new_version}}, \code{ \link{create_dataset}}

\describe{
\item{ \strong{\code{ \link{convertFromJafroc}}}}{ If you have already have a data as a JAFROC formulation.}
\item{ \strong{\code{ \link{dataset_creator_new_version}}}}{ Enter TP and FP data into table. }
\item{ \strong{\code{ \link{create_dataset}}}}{ Enter TP and FP data by interactive manner.}
}

This package includes FROC datasets.
Before running the function, we can confirm dataset is correctly formulated by the function \strong{\code{ \link{viewdata}}}.


-------------------------------------------------------------------------------------------------


------------  \strong{Single reader and single modality (SRSC) case.}   --------------


------------------------------------------------------------------------------------------------

In single reader and single modality case (srsc), it should be a list which includes  \code{f, h, NL, NI, C}.

\describe{
\item{ \code{f}  }{Number of False Alarms. This is a vector for each confidence level.}
\item{ \code{h}  }{Number of Hits. This is a vector for each confidence level.}
\item{ \code{NL} }{Number of Lesions. This is a positive integer.}
\item{ \code{NI} }{Number of Images. This is a positive integer.}
\item{ \code{C}  }{ Confidence level. This is a positive integer.}
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
\code{c } is not required, since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from input data, where \code{C} is the number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ Example data:}}

 \emph{            A single reader and single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms  } \tab \strong{No. of  hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  ------------------------\tab ------------------------ \tab ------------------------------ \tab ------------- \cr
definitely present = \tab  5 \tab 1 \tab 41 \cr
 probably present  = \tab  4 \tab 2 \tab 22 \cr
 equivocal         = \tab  3 \tab 5 \tab 14  \cr
 probably absent   = \tab  2 \tab 11 \tab 8  \cr
 questionable      = \tab  1 \tab 13 \tab 1  \cr
 }

---------------------------------------------------------------------------------------------------

The first column do not required, since from \code{C} the program generate it by the \code{rep(C:1)}.
So you should check the compatibility of your data and the program's generating new confidence  level column by
a function \code{viewdata()}.


Note that the above example data must be made by the following manner:
\code{ dat <- list(       }

\code{ h = c(41,22,14,8,1),   }

\code{ f = c(1,2,5,11,13),    }

\code{ NL = 124,     }

\code{ NI = 63,    }

\code{ C = 5)         }

And using this object \code{dat}, we can apply \code{fit_Bayesian_FROC()} as \code{fit_Bayesian_FROC(dat)}.
---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


For  multiple readers and multiple modalities case, i.e., MRMC case,
to apply the function \code{fit_Bayesian_FROC()}, an R list object of data
must have components \code{m,q,c,h,f,NL,C,M,Q}:
\describe{
\item{ \code{C }  }{The highest number of confidence level, this is a scalar.}
\item{ \code{M }  }{The number of modalities.}
\item{ \code{Q }  }{The number of readers.}
\item{ \code{c }  }{The confidence level vector This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{The modality ID vector.}
\item{ \code{q }  }{The reader ID vector.}
\item{ \code{h }  }{The number of hits vector.}
\item{ \code{f }  }{The number of false alarm vector.}
\item{ \code{NL }  }{The Total number of lesions for all images, this is a scalar.}
}
The detail of these dataset, please see the example datasets ( the section \strong{See Also} in the below) in this package.



Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{viewdata_MRMC}.


\strong{\emph{ Example data:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }
---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ ReaderID} \tab   \strong{ModalityID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------- \tab -------------- \tab ------------------------- \tab  ------------------- \tab -----------------\cr
  1 \tab 1 \tab 5 \tab  1\tab 15\cr
  1 \tab 2 \tab 4  \tab 3\tab 14\cr
  1 \tab 3 \tab 3  \tab 5\tab 5\cr
  1 \tab 1 \tab 2  \tab 5\tab 3\cr
  1 \tab 2 \tab 1  \tab 9\tab 4\cr
  1 \tab 3 \tab 5  \tab 1\tab 14\cr
  1 \tab 1 \tab 4  \tab 2\tab 13\cr
  1 \tab 2 \tab 3  \tab 2\tab 5\cr
  1 \tab 3 \tab 2 \tab 5\tab 3\cr
  2 \tab 1 \tab 1 \tab  6\tab 4\cr
  2 \tab 2 \tab 5  \tab 1\tab 14\cr
  2 \tab 3 \tab 4  \tab 1\tab 4\cr
  2 \tab 1 \tab 3  \tab 1\tab 1\cr
  2 \tab 2 \tab 2  \tab 2\tab 2\cr
  2 \tab 3 \tab 1  \tab 3\tab 2\cr
  2 \tab 1 \tab 5  \tab 1\tab 13\cr
  2 \tab 2 \tab 4 \tab 2\tab 4\cr
  2 \tab 3 \tab 3  \tab 1\tab 2\cr }
---------------------------------------------------------------------------------------------------}

\item{StanS4class}{This is an output of \code{rstan::stan()}. More precisely, an object of the inherited class of the S4 class stanfit.
That is, the stanfitExtended S4 class defined in this package.}
}
\description{
Plot FROC curves based on two parameters a and b.
}
