% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{clust_cp_epi}
\alias{clust_cp_epi}
\title{Clustering Epidemiological survival functions with common changes in time}
\usage{
clust_cp_epi(
  data,
  n_iterations,
  M,
  B,
  L,
  gamma = 1/8,
  alpha = 1,
  q = 0.1,
  dt = 0.1,
  a0 = 4,
  b0 = 10,
  c0 = 1,
  d0 = 1,
  MH_var = 0.01,
  S0 = 1,
  R0 = 0,
  p = 0.003,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a matrix where each entry is the number of infected for a population (row) at a specific discrete time (column).}

\item{n_iterations}{Second value}

\item{M}{number of Monte Carlo iterations when computing the likelihood of the survival function.}

\item{B}{number of orders for the normalisation constant.}

\item{L}{number of split-merge steps for the proposal step.}

\item{gamma}{recovery rate fixed constant for each population at each time.}

\item{alpha}{\eqn{\alpha} for the acceptance ration in the split-merge procedure.}

\item{q}{probability of performing a split when updating the single order for the proposal procedure.}

\item{dt, a0, b0, c0, d0}{parameters for the computation of the integrated likelihood of the survival functions.}

\item{MH_var}{variance for the Metropolis-Hastings estimation of the proportion of infected at time 0.}

\item{S0, R0}{parameters for the SDE solver.}

\item{p}{prior average number of change points for each order.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{clust_cp_epi} returns a list containing the following components: \itemize{
\item{\code{$clust}} a matrix where each row corresponds to the output cluster of the corresponding iteration.
\item{\code{$orders}} a multidimensional matrix where each slice is a matrix with the orders associated to the output cluster of that iteration.
\item{\code{time}} computational time in seconds.
\item{\code{$llik}} a matrix containing the log-likelihood of each population at each iteration.
\item{\code{$rho}} traceplot for the proportion of infected individuals at time 0.
}
}
\description{
Clustering Epidemiological survival functions with common changes in time
}
\examples{
\donttest{
data_mat <- matrix(NA, nrow = 5, ncol = 50)

betas <- list(c(rep(0.45, 25),rep(0.14,25)),
              c(rep(0.55, 25),rep(0.11,25)),
              c(rep(0.50, 25),rep(0.12,25)),
              c(rep(0.52, 10),rep(0.15,40)),
              c(rep(0.53, 10),rep(0.13,40)))

 inf_times <- list()

 for(i in 1:5){

   inf_times[[i]] <- sim_epi_data(10000, 10, 50, betas[[i]], 1/8)

   vec <- rep(0,50)
   names(vec) <- as.character(1:50)

   for(j in 1:50){
     if(as.character(j) \%in\% names(table(floor(inf_times[[i]])))){
       vec[j] = table(floor(inf_times[[i]]))[which(names(table(floor(inf_times[[i]]))) == j)]
     }
   }
   data_mat[i,] <- vec
 }

 out <- clust_cp_epi(data = data_mat, n_iterations = 3000, M = 250, B = 1000, L = 1)

}
}
