% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract-TidySet}
\alias{extract-TidySet}
\alias{$,TidySet-method}
\alias{$<-,TidySet-method}
\alias{[,TidySet-method}
\alias{[<-,TidySet-method}
\alias{[[,TidySet-method}
\alias{[[<-,TidySet-method}
\title{Extract}
\usage{
\S4method{$}{TidySet}(x, name)

\S4method{$}{TidySet}(x, name) <- value

\S4method{[}{TidySet}(x, i, j, k, ..., drop = TRUE)

\S4method{[}{TidySet}(x, i, j, k, ...) <- value

\S4method{[[}{TidySet}(x, i, j, ..., exact = TRUE)

\S4method{[[}{TidySet}(x, i) <- value
}
\arguments{
\item{x}{A TidySet object.}

\item{name}{The data about the TidysSet object to extract.}

\item{value}{The value to overwrite}

\item{i}{Which rows do you want to keep? By default all.}

\item{j}{Which slot do you want to extract? One of "sets", "elements" or
"relations".}

\item{k}{Which columns do you want to extract. By default all.}

\item{...}{Other arguments currently ignored.}

\item{drop}{Remove remaining elements, sets and relations? Passed to all
arguments of \code{\link[=droplevels]{droplevels()}}.}

\item{exact}{A logical value. FALSE if fuzzy matching is wanted.
Add values to the TidySet. Allows to control to which slot is it added.}
}
\value{
Always returns a valid \link{TidySet}.
}
\description{
Operators acting on TidySet to extract or replace parts.
They are designed to resemble the basic operators.
}
\examples{
TS <- tidySet(list(A = letters[1:5], B = letters[6]))
TS[, "sets", "origin"] <- sample(c("random", "non-random"), 2, replace = TRUE)
TS[, "sets", "type"] <- c("Fantastic", "Wonderful")
# This produces a warning
# Better to be explicit:
TS[, "relations", "description"] <- c("What", "can", "I", "say", "now", "?")
relations(TS)
TS[, "elements", "description"] <- rev(c("What", "can", "I", "say", "now", "?"))
elements(TS)
# Which will be deleted?
# TS$description <- NULL
TS$type
TS$origin <- c("BCN", "BDN")
# Different subsets
TS[1, "elements"]
TS[1, "sets"]
# Always print
TS
TS[, "sets", c("type", "origin")] # Same
TS[, "sets", "origin"] # Drop column type
is(TS[, "sets", "origin"])
TS[, "sets"]
TS[["A"]]
TS[["B"]]
TS[["C"]] # Any other set is the empty set
}
