% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartesian.R
\name{cartesian}
\alias{cartesian}
\alias{cartesian.TidySet}
\title{Create the cartesian product of two sets}
\usage{
cartesian(object, set1, set2, name = NULL, ...)

\method{cartesian}{TidySet}(
  object,
  set1,
  set2,
  name = NULL,
  keep = TRUE,
  keep_relations = keep,
  keep_elements = keep,
  keep_sets = keep,
  ...
)
}
\arguments{
\item{object}{A TidySet object.}

\item{set1, set2}{The name of the sets to be used for the cartesian product}

\item{name}{The name of the new set.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}

\item{keep}{A logical value if you want to keep.}

\item{keep_relations}{A logical value if you wan to keep old relations.}

\item{keep_elements}{A logical value if you wan to keep old elements.}

\item{keep_sets}{A logical value if you wan to keep old sets.}
}
\value{
A TidySet object with the new set
}
\description{
Given two sets creates new sets with one element of each set
}
\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b"),
    elements = letters[seq_len(6)]
)
TS <- tidySet(relations)
cartesian(TS, "a", "b")
}
\seealso{
Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
