% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{HeatMapFeeding}
\alias{HeatMapFeeding}
\alias{HeatMapFeeding,Eval-method}
\title{Function for plotting heatmap of feeding between two selected cell models}
\usage{
HeatMapFeeding(object, speciesA, speciesB, var_nr)

\S4method{HeatMapFeeding}{Eval}(object, speciesA, speciesB, var_nr)
}
\arguments{
\item{object}{An object of class Eval.}

\item{speciesA}{The sequence number of the first cell model in names(object@specs)}

\item{speciesB}{The sequence number of the second cell model in names(object@specs)}

\item{var_nr}{The number of the most varying speciesA's substances following plotSpecActivity structure}
}
\value{
Heatmap (ggplot2)
}
\description{
The generic function \code{HeatMapFeeding} returns a heatmap between two selected cell models. If there is feeding, the heatmap show only 
the producer. The compounds are originated from the most varying substances of the first cell model called "speciesA".
}
\examples{
sim <- sihumi_test
HeatMapFeeding(object = sim, speciesA = 1, speciesB = 2, var_nr = 78)

}
