% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_log.R
\name{safe_log}
\alias{safe_log}
\title{Take logarithm avoiding underflow}
\usage{
safe_log(x)
}
\arguments{
\item{x}{vector}
}
\value{
vector log in base e of input or minimum possible log value of -744.4401
}
\description{
Returns the normal log if there is no underflow. If there is underflow, then
returns the minimum for which log can return (-744.4401)
}
\examples{
log(c(1e-323, 1e-324))      # gives -Inf for the second value
safe_log(c(1e-323, 1e-324)) # gives the minimum value of -744.4401
}

