% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,mixedRegression-method}
\alias{simulate,mixedRegression-method}
\title{Simulation of hierarchical (mixed) regression model}
\usage{
\S4method{simulate}{mixedRegression}(object, nsim = 1, seed = NULL, t,
  plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "mixedRegression"}

\item{nsim}{number of data sets to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of regression model
  \eqn{y_{ij} = f(\phi_j, t_{ij}) + \epsilon_{ij}, \phi_j\sim N(\mu, \Omega),
  \epsilon_{ij}\sim N(0,\gamma^2\widetilde{s}(t_{ij}))}.
}
\examples{
mu <- 2; Omega <- 0.4; phi <- matrix(rnorm(21, mu, sqrt(Omega)))
model <- set.to.class("mixedRegression",
   parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
   fun = function(phi, t) phi*t, sT.fun = function(t) t)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
}

