% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,Merton-method}
\alias{estimate,Merton-method}
\title{Estimation for jump diffusion process}
\usage{
\S4method{estimate}{Merton}(model.class, t, data, nMCMC, propSd, adapt = TRUE,
  proposal = c("normal", "lognormal"), it.xi = 10)
}
\arguments{
\item{model.class}{class of the jump diffusion model including all required information, see \code{\link{Merton-class}}}

\item{t}{vector of time points}

\item{data}{vector of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\xi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density for xi: "normal" (default) or "lognormal"}

\item{it.xi}{number of iterations for MH step for \eqn{\xi} inside the Gibbs sampler}
}
\description{
Bayesian estimation of a stochastic process
  \eqn{Y_t = y_0 \exp( \phi t - \gamma^2/2 t+\gamma W_t + \log(1+\theta) N_t)}.
}
\examples{
model <- set.to.class("Merton", parameter = list(thetaT = 0.1, phi = 0.05, gamma2 = 0.1, xi = 10))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5, plot.series = TRUE)
est <- estimate(model, t, data, 1000)
plot(est)
\dontrun{
est_hidden <- estimate(model, t, data$Y, 1000)
plot(est_hidden)
}
}
\references{
Hermann, S. and F. Ruggeri (2016). Modelling Wear Degradation in Cylinder Liners.
SFB 823 discussion paper 06/16.

Hermann, S., K. Ickstadt and C. H. Mueller (2015).
Bayesian Prediction for a Jump Diffusion Process with Application to Crack Growth in Fatigue Experiments.
SFB 823 discussion paper 30/15.
}

