% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{BuliResponse}
\alias{BuliResponse}
\title{Bundesliga Data Response Data (BuliResponse)}
\format{A data set containing all information that is necessary to create a response object
for the Bundesliga data \code{link{Buli1516}}
\describe{ 
\item{Result}{Ordinal, 5-categorical results from Bundesliga season 2015/16.}
\item{TeamHome}{Abbreviation of home team.}
\item{TeamAway}{Abbreviation of away team.}
\item{Matchday}{Matchdays from 1 to 34.}
}}
\source{
\url{http://www.kicker.de/}
}
\description{
Data from the German Bundesliga from the season 2015/16. The data contain all 
variables from the 306 matches that are necessary to create the respective 
\code{response.BTLLasso} object from the data set \code{\link{Buli1516}}.  The purpose
of the data set is to provide an example how \code{response.BTLLasso} objects can be created.
}
\examples{
\dontrun{
data(BuliResponse)

Y.Buli <- response.BTLLasso(response = BuliResponse$Result, 
                            first.object = BuliResponse$TeamHome,
                            second.object = BuliResponse$TeamAway,
                            subject = BuliResponse$Matchday)
}
}
\references{
Schauberger, Gunther, Groll Andreas and Tutz, Gerhard (2016): Modelling 
Football Results in the German Bundesliga Using Match-specific Covariates, 
\emph{Department of Statistics, LMU Munich}, Technical Report 197
}
\keyword{datasets}
