% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsl.R
\name{bsl}
\alias{bsl}
\title{Performing BSL, BSLasso and semiBSL}
\usage{
bsl(y, n, M, theta0, covRandWalk, fnSim, fnSum, method = c("BSL",
  "semiBSL")[1], shrinkage = NULL, penalty = NULL, fnPrior = NULL,
  simArgs = NULL, sumArgs = NULL, logitTransformBound = NULL,
  standardise = FALSE, parallel = FALSE, parallelArgs = NULL,
  thetaNames = NULL, plotOnTheFly = FALSE, verbose = FALSE)
}
\arguments{
\item{y}{The observed data - note this should be the raw dataset NOT the set of summary statistics.}

\item{n}{The number of simulations from the model per MCMC iteration for estimating the synthetic likelihood.}

\item{M}{The number of MCMC iterations.}

\item{theta0}{Initial guess of the parameter value, which is used as the starting value for MCMC.}

\item{covRandWalk}{A covariance matrix to be used in multivariate normal random walk proposals.}

\item{fnSim}{A function that simulates data for a given parameter value. The first argument should be the
parameters. Other necessary arguments (optional) can be specified with \code{simArgs}.}

\item{fnSum}{A function for computing summary statistics of data. The first argument should be the observed
or simulated dataset. Other necessary arguments (optional) can be specified with \code{sumArgs}.}

\item{method}{A string argument indicating the method to be used. The default, 'BSL', runs standard BSL or
BSLasso if \code{shrinkage} is used. 'semiBSL' runs the semi-parametric BSL algorithm and is more robust to
non-normal summary statistics.}

\item{shrinkage}{A string argument indicating which shrinkage method to be used. The default is \code{NULL},
which means no shrinkage is used. Current options are 'glasso' for graphical lasso and 'Warton' for the
ridge regularisation method of Warton (2008).}

\item{penalty}{The penalty value to be used for the specified shrinkage method. Must be between zero and one
if the shrinkage method is 'Warton'.}

\item{fnPrior}{A function that computes the prior density for a parameter. The default is \code{NULL}, which
is an improper flat prior over the real line for each parameter. The function must have a single input: a vector
of parameter values.}

\item{simArgs}{A list of additional arguments to pass into the simulation function. Only use when the input
\code{fnSim} requires additional arguments. The default is \code{NULL}.}

\item{sumArgs}{A list of additional arguments to pass into the summary statistics function. Only use when the
input \code{fnSum} requires additional arguments. The default is \code{NULL}.}

\item{logitTransformBound}{A \eqn{p} by \eqn{2} numeric matrix indicating the upper and lower bound of parameters if a logit
transformation is used on the parameter space, where \eqn{p} is the number of parameters. The default is \code{NULL},
which means no logit transformation is used. It is also possible to define other transformations with \code{fnSim}
and \code{fnPrior}. The first column contains the lower bound of each parameter and the second column contains the
upper bound. Infinite lower or upper bound is also supported, eg. \code{matrix(c(1,Inf,0,10,-Inf,0.5),3,2,byrow=TRUE)}.}

\item{standardise}{A logical argument that determines whether to standardise the summary statistics before applying
the graphical lasso. This is only valid if shrinkage is 'glasso' and penalty is not \code{NULL}. The diagonal
elements will not be penalised if the shrinkage method is 'glasso'. The default is \code{FALSE}.}

\item{parallel}{A logical value indicating whether parallel computing should be used for simulation and summary
statistic evaluation. The default is \code{FALSE}. When model simulation is fast, it may be preferable to perform
serial computations to avoid significant communication overhead between workers.}

\item{parallelArgs}{A list of additional arguments to pass into the \code{foreach} function. Only used when parallel
computing is enabled, default is \code{NULL}.}

\item{thetaNames}{A string vector of parameter names, which must have the same length as the parameter vector.
The default is \code{NULL}.}

\item{plotOnTheFly}{A logical argument. If \code{TRUE}, a plot of approximate univariate posteriors based on the
current accepted samples will be shown every 1000 iterations. The default is \code{FALSE}.}

\item{verbose}{A logical argument indicating whether the iteration numbers (\code{1:M}) and accepted proposal
flags should be printed to track progress. The default is \code{FALSE}.}
}
\value{
An object of class \code{bsl} is returned, containing the following components:
\itemize{
\item \code{theta}: MCMC samples from the joint approximate posterior distribution of the parameters.
\item \code{loglike}: Accepted MCMC samples of the estimated log-likelihood values.
\item \code{acceptanceRate}: The acceptance rate of the MCMC algorithm.
\item \code{earlyRejectionRate}: The early rejection rate of the algorithm (early rejection may occur when using
bounded prior distributions).
\item \code{call}: The original code that was used to call the method.
\item \code{y}: The input observed data.
\item \code{n}: The input number of simulations from the model per MCMC iteration.
\item \code{M}: The input number of MCMC iterations.
\item \code{theta0}: The input initial guess of the parameter value.
\item \code{covRandWalk}: The input covariance matrix used in multivariate normal random walk proposals.
\item \code{fnSim}: The input data simulation function.
\item \code{fnSum}: The input function for computing summary statistics of data.
\item \code{method}: The input string argument indicating the used method.
\item \code{shrinkage}: The input string argument indicating the shrinkage method.
\item \code{penalty}: The input penalty value.
\item \code{fnPrior}: The input function that computes the prior density for a parameter.
\item \code{simArgs}: The input list of additional arguments to pass into the simulation function.
\item \code{sumArgs}: The input list of additional arguments to pass into the summary statistics function.
\item \code{logitTransform}: The logical argument indicating whether a logit transformation is used in the algorithm.
\item \code{logitTransformBound}: The input matrix of logitTransformBound.
\item \code{standardise}: The input logical argument that determines whether to standardise the summary statistics.
\item \code{parallel}: The input logical value indicating whether parallel computing is used in the process.
\item \code{parallelArgs}: The input list of additional arguments to pass into the \code{foreach} function.
\item \code{thetaNames}: The string vector of parameter names.
\item \code{time}: The running time of class \code{difftime}.
}
}
\description{
This is the main function for performing MCMC BSL, MCMC BSLasso and MCMC semiBSL.
Parallel computing is supported with the R package \code{foreach}.
}
\references{
Price, L. F., Drovandi, C. C., Lee, A., & Nott, D. J. (2018).
Bayesian synthetic likelihood. Journal of Computational and Graphical Statistics.
\url{https://doi.org/10.1080/10618600.2017.1302882}

An, Z., South, L. F., Nott, D. J. &  Drovandi, C. C. (2018a). Accelerating Bayesian synthetic
likelihood with the graphical lasso. Journal of Computational and Graphical Statistics.
\url{https://doi.org/10.1080/10618600.2018.1537928}

An, Z., Nott, D. J. &  Drovandi, C. (2018b). Robust Bayesian Synthetic Likelihood via
a Semi-Parametric Approach. ArXiv Preprint \url{https://arxiv.org/abs/1809.05800}

Warton, D. I. (2008). Penalized Normal Likelihood and Ridge Regularization of Correlation and
Covariance Matrices, Journal of the American Statistical Association.
\url{https://doi.org/10.1198/016214508000000021}
}
\seealso{
\code{\link{selectPenalty}} for a function to tune the BSLasso tuning parameter
and \code{\link{plot}} for functions related to visualisation.
}
\author{
Ziwen An, Leah F. South and Christopher C. Drovandi
}
