% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Archaeo}
\alias{Archaeo}
\title{Radiocarbon ages of observations taken from an archaeological site}
\format{A data frame/tibble  with 60 observations on two variables
\describe{ 
\item{age}{number of years before 1983 - the year the data were obtained}
\item{phase}{Ceramic Phase numbers} 
}}
\source{
Cunliffe, B. (1984) and Naylor and Smith (1988).
}
\usage{
Archaeo
}
\description{
Data for Exercises 5.120, 10.20 and Example 1.16
}
\examples{

boxplot(age ~ phase, data = Archaeo, col = "yellow", 
        main = "Example 1.16", xlab = "Ceramic Phase", ylab = "Age")
anova(lm(age ~ as.factor(phase), data= Archaeo))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
