% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_table.R
\name{ce_table}
\alias{ce_table}
\title{Cost-effectiveness summary statistics table}
\usage{
ce_table(he, wtp = 25000, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{wtp}{Willingness to pay}

\item{...}{Additional parameters}
}
\description{
As is commonly shown in a journal paper.
}
\examples{
data(Vaccine)

# Runs the health economic evaluation using BCEA
m <- bcea(
      e=eff,
      c=cost,               # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e, c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0, Kmax)
)
ce_table(m)
}
\keyword{internal}
