\name{summary.mixedAn}
\alias{summary.mixedAn}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Summary methods for objects in the class "mixedAn" (mixed analysis)
}
\description{
Prints a summary table for the results of the mixed analysis for the economic evaluation of a given model 
}
\usage{
\method{summary}{mixedAn}(object, wtp = 25000,...)
%%summary(object, wtp = 25000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
An object of the class "mixedAn", which is the results of the function mixedAn(), generating the economic evaluation of a set of interventions, considering given market shares for each option
}
  \item{wtp}{
The value of the willingness to pay choosen to present the analysis
}
\item{...}{
Additional arguments affecting the summary produced
}
}

\value{
Produces a table with summary information on the loss in expected value of information generated by the inclusion of non-cost-effective interventions in the market
}
\references{
Baio, G. and Russo, P. (2009).A decision-theoretic framework for the application of cost-effectiveness analysis in regulatory processes. Pharmacoeconomics 27(8), 645-655 doi:10.2165/11310250

Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity Analysis in Health Economics. Statistical Methods in Medical Research doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London
}

\author{
Gianluca Baio
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{bcea}},
\code{\link{mixedAn}}
}
\examples{
# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem
#
# Load the processed results of the MCMC simulation model
data(Vaccine)
# 
# Runs the health economic evaluation using BCEA
m <- bcea(e=e,c=c,          # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000            # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
)
#
ma <- mixedAn(m,        # uses the results of the mixed strategy 
                        #  analysis (a "mixedAn" object)
       mkt.shares=NULL  # the vector of market shares can be defined 
                        #  externally. If NULL, then each of the T 
                        #  interventions will have 1/T market share
)
#
# Prints a summary of the results
summary(ma,       # uses the results of the mixed strategy analysis 
                  #  (a "mixedAn" object)
     wtp=25000    # selects the relevant willingness to pay 
                  #  (default: 25,000) 
)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Health economic evaluation}
\keyword{Mixed analysis}
