% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_neighboringDAGs.R
\name{get_neighboringDAGs}
\alias{get_neighboringDAGs}
\title{Enumerate all neighbors of a DAG}
\usage{
get_neighboringDAGs(DAG)
}
\arguments{
\item{DAG}{Adjacency matrix of a DAG}
}
\value{
The \eqn{(q,q,K)} array containing all neighboring DAGs, with \eqn{K} being the total number of neighbors
}
\description{
This functions takes any DAG with \eqn{q} nodes as input and returns all the neighboring DAGs, i.e. all those DAGs that
can be reached by the addition, removal or reversal of an edge.
}
\examples{
# Randomly generate a DAG
q <- 4; w <- 0.2
set.seed(123)
DAG <- rDAG(q,w)
# Get neighbors
neighbors <- get_neighboringDAGs(DAG)
neighbors
}
