% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_add_adv_stats.R
\name{do_add_adv_stats}
\alias{do_add_adv_stats}
\title{Advanced statistics}
\usage{
do_add_adv_stats(df)
}
\arguments{
\item{df}{Data frame with the games and the players info.}
}
\value{
Data frame.
}
\description{
This function adds to the whole data frame the advanced statistics 
for every player in every game.
}
\details{
The advanced statistics computed are as follows:
\itemize{
\item GameSc: Game Score.
\item PIE: Player Impact Estimate.
\item EFGPerc: Effective Field Goal Percentage.
\item ThreeRate: Three points attempted regarding the total field goals attempted.
\item FRate: Free Throws made regarding the total field goals attempted.
\item STL_TOV: Steal to Turnover Ratio.
\item AST_TOV: Assist to Turnover Ratio.
\item PPS: Points Per Shot.
\item OE: Offensive Efficiency.
\item EPS: Efficient Points Scored. 
}

The detailed definition of some of these stats can be found at
\url{https://www.basketball-reference.com/about/glossary.html} and
\url{https://stats.nba.com/help/glossary/}.
}
\examples{
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
          
}
\seealso{
\code{\link{do_OE}}, \code{\link{do_EPS}}
}
\author{
Guillermo Vinue
}
