% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_vm_fns.R
\name{rvmmix}
\alias{rvmmix}
\alias{dvmmix}
\title{The univariate von Mises mixtures}
\usage{
rvmmix(n, kappa, mu, pmix)

dvmmix(x, kappa, mu, pmix)
}
\arguments{
\item{n}{number of observations. Ignored if at least one of the other parameters have length k > 1, in which
case, all the parameters are recycled to length k to produce k random variates.}

\item{kappa}{vector of component concentration (inverse-variance) parameters, \code{kappa > 0}.}

\item{mu}{vector of component means.}

\item{pmix}{vector of mixing proportions.}

\item{x}{vector of angles (in radians) where the densities are to be evaluated.}
}
\value{
\code{dvmmix} computes the density  and \code{rvmmix} generates random deviates from the mixture density.
}
\description{
The univariate von Mises mixtures
}
\details{
\code{pmix}, \code{mu} and \code{kappa} must be of the same length, with \eqn{j}-th element corresponding to the \eqn{j}-th component of the mixture distribution.

The univariate von Mises mixture distribution with component size \code{K = \link{length}(pmix)} has density
\deqn{g(x) = p[1] * f(x; \kappa[1], \mu[1]) + ... + p[K] * f(x; \kappa[K], \mu[K])}
where \eqn{p[j], \kappa[j], \mu[j]} respectively denote the mixing proportion, concentration parameter and the mean parameter for the \eqn{j}-th component
and \eqn{f(. ; \kappa, \mu)} denotes the density function of the (univariate) von Mises distribution with mean parameter \eqn{\mu} and concentration parameter \eqn{\kappa}.
}
\examples{
kappa <- 1:3
mu <- 0:2
pmix <- c(0.3, 0.3, 0.4)
x <- 1:10
n <- 10

# mixture densities calculated at each point in x
dvmmix(x, kappa, mu, pmix)

# number of observations generated from the mixture distribution is n
rvmmix(n, kappa, mu, pmix)

}
