% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{d_fitted}
\alias{d_fitted}
\alias{r_fitted}
\title{Density and random deviates from an angmcmc object}
\usage{
d_fitted(x, object, fn = mean, burnin = 1/3, thin = 1)

r_fitted(n, object, fn = mean, burnin = 1/3, thin = 1)
}
\arguments{
\item{x}{vector (if univariate) or a two column matrix (if bivariate, with each row a 2-D vector) of points where the
densities are to be computed.}

\item{object}{angular MCMC object. The dimension of the model must match with \code{x}.}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{n}{number of observations to be generated.}
}
\value{
\code{d_fitted} gives a vector the densities computed at the given points  and \code{r_fitted}
creates a vector (if univariate) or a matrix (if bivariate) with each row being a 2-D point, of random deviates.
}
\description{
Density and random deviates from an angmcmc object
}
\details{
To estimate the mixture density, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples (using the function \link{pointest}), yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.

The random deviates are generated from the estimated mixture density \eqn{f(x|\hat{\eta})}.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
d_fitted(c(0,0), fit.vmsin.20)
r_fitted(10, fit.vmsin.20)
}

