% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage_metadata.R
\name{get_storage_metadata}
\alias{get_storage_metadata}
\alias{get_storage_metadata.blob_container}
\alias{get_storage_metadata.file_share}
\alias{get_storage_metadata.adls_filesystem}
\alias{set_storage_metadata}
\alias{set_storage_metadata.blob_container}
\alias{set_storage_metadata.file_share}
\alias{set_storage_metadata.adls_filesystem}
\title{Get/set user-defined metadata for a storage object}
\usage{
get_storage_metadata(object, ...)

\method{get_storage_metadata}{blob_container}(object, blob, ...)

\method{get_storage_metadata}{file_share}(object, file, isdir, ...)

\method{get_storage_metadata}{adls_filesystem}(object, file, ...)

set_storage_metadata(object, ...)

\method{set_storage_metadata}{blob_container}(object, blob, ..., keep_existing = TRUE)

\method{set_storage_metadata}{file_share}(object, file, isdir, ..., keep_existing = TRUE)

\method{set_storage_metadata}{adls_filesystem}(object, file, ..., keep_existing = TRUE)
}
\arguments{
\item{object}{A blob container, file share or ADLS filesystem object.}

\item{...}{For the metadata setters, name-value pairs to set as metadata for a blob or file.}

\item{blob, file}{Optionally the name of an individual blob, file or directory within a container.}

\item{isdir}{For the file share method, whether the \code{file} argument is a file or directory. If omitted, \code{get_storage_metadata} will auto-detect the type; however this can be slow, so supply this argument if possible.}

\item{keep_existing}{For the metadata setters, whether to retain existing metadata information.}
}
\value{
\code{get_storage_metadata} returns a named list of metadata properties. If the \code{blob} or \code{file} argument is present, the properties will be for the blob/file specified. If this argument is omitted, the properties will be for the container itself.

\code{set_storage_metadata} returns the same list after setting the object's metadata, invisibly.
}
\description{
Get/set user-defined metadata for a storage object
}
\details{
These methods let you get and set user-defined properties (metadata) for storage objects.
}
\examples{
\dontrun{

fs <- storage_container("https://mystorage.dfs.core.windows.net/myshare", key="access_key")
create_storage_dir("newdir")
storage_upload(share, "iris.csv", "newdir/iris.csv")

set_storage_metadata(fs, "newdir/iris.csv", name1="value1")
# will be list(name1="value1")
get_storage_metadata(fs, "newdir/iris.csv")

set_storage_metadata(fs, "newdir/iris.csv", name2="value2")
# will be list(name1="value1", name2="value2")
get_storage_metadata(fs, "newdir/iris.csv")

set_storage_metadata(fs, "newdir/iris.csv", name3="value3", keep_existing=FALSE)
# will be list(name3="value3")
get_storage_metadata(fs, "newdir/iris.csv")

# deleting all metadata
set_storage_metadata(fs, "newdir/iris.csv", keep_existing=FALSE)

}
}
\seealso{
\link{blob_container}, \link{file_share}, \link{adls_filesystem}

\link{get_storage_properties} for standard properties
}
