% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_registry.R
\docType{class}
\name{DockerRegistry}
\alias{DockerRegistry}
\title{Docker registry class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
DockerRegistry
}
\description{
Class representing a \href{https://docs.docker.com/registry/}{Docker registry}. Note that this class can be used to interface with any Docker registry that supports the HTTP V2 API, not just those created via the Azure Container Registry service. Use the \link{docker_registry} function to instantiate new objects of this class.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{login(...)}: Do a local login to the registry via \code{docker login}; necessary if you want to push and pull images. By default, instantiating a new object of this class will also log you in. See 'Details' below.
\item \code{push(src_image, dest_image)}: Push an image to the registry, using \code{docker tag} and \code{docker push}.
\item \code{pull(image)}: Pull an image from the registry, using \code{docker pull}.
\item \code{get_image_manifest(image, tag="latest")}: Gets the manifest for an image.
\item \code{get_image_digest(image, tag="latest")}: Gets the digest (SHA hash) for an image.
\item \code{delete_image(image, digest, confirm=TRUE)}: Deletes an image from the registry.
\item \code{list_repositories()}: Lists the repositories (images) in the registry.
}
}

\section{Details}{

The arguments to the \code{login()} method are:
\itemize{
\item \code{tenant}: The Azure Active Directory (AAD) tenant for the registry.
\item \code{username}: The username that Docker will use to authenticate with the registry. This can be either the admin username, if the registry was created with an admin account, or the ID of a registered app that has access to the registry.
\item \code{password}: The password that Docker will use to authenticate with the registry.
\item \code{app}: The app ID to use to authenticate with the registry. Set this to NULL to authenticate with a username and password, rather than via AAD.
\item \code{...}: Further arguments passed to \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}.
\item \code{token}: An Azure token object. If supplied, all authentication details will be inferred from this.
}

The \code{login()}, \code{push()} and \code{pull()} methods for this class call the \code{docker} commandline tool under the hood. This allows all the features supported by Docker to be available immediately, with a minimum of effort. Any calls to the \code{docker} tool will also contain the full commandline as the \code{cmdline} attribute of the (invisible) returned value; this allows scripts to be developed that can be run outside R.
}

\examples{
\dontrun{

reg <- docker_registry("myregistry")

reg$list_repositories()

# create an image from a Dockerfile in the current directory
call_docker("build -t myimage .")

# push the image
reg$push("myimage")

reg$get_image_manifest("myimage")
reg$get_image_digest("myimage")

}
}
\seealso{
\link{acr}, \link{docker_registry}, \link{call_docker}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker commandline reference}

\href{https://docs.docker.com/registry/spec/api/}{Docker registry API}
}
\keyword{datasets}
