% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twodviews.R
\name{twodviews}
\alias{twodviews}
\title{twodviews
Combine and calculate the PCscores matrix from a list of different landmark configurations to be combined}
\usage{
twodviews(twodlist, scale = TRUE, vector = NULL)
}
\arguments{
\item{twodlist}{a list containing the landmark configurations of each anatomical view stored as separated lists}

\item{scale}{logical: TRUE for shape-space, FALSE for form-space}

\item{vector}{numeric vector: defines which views are to be used}
}
\value{
PCscores PC scores

PCs Pricipal Components (eigenvector matrix)

Variance table of the explained variance by the PCs

size vector containing the Centroid Size of each configuration

mshapes a list containing the mean shape of each landmark configuration

dims number of landmarks of each configuration

dimm dimension (2D or 3D) of each combined landmark configuration

twodlist the list used as input
}
\description{
twodviews
Combine and calculate the PCscores matrix from a list of different landmark configurations to be combined
}
\examples{
library(Morpho)
#load the 2D primate dataset
data("Lset2D_list")
length(Lset2D_list)
#combine the 2D datasets and PCA
combin2D<-twodviews(Lset2D_list,scale=TRUE,vector=c(1:5))
combin2D$size
#plot of the first two Principal Components
plot(combin2D$PCscores)
text(combin2D$PCscores,labels=rownames(combin2D$PCscores))
#load the 3D primate dataset
data("Lset3D_array")
#GPA and PCA
GPA_3D<-procSym(Lset3D_array)
#plot of the first two Principal Components
plot(GPA_3D$PCscores)
text(GPA_3D$PCscores,labels=rownames(GPA_3D$PCscores))
}
\references{
Profico, A., Piras, P., Buzi, C., Del Bove, A., Melchionna, M., Senczuk, G., ... & Manzi, G. (2019). 
Seeing the wood through the trees. Combining shape information from different landmark configurations. Hystrix, 157-165.
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
