% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object.R
\docType{class}
\name{Andromeda-class}
\alias{Andromeda-class}
\alias{Andromeda}
\alias{show,Andromeda-method}
\alias{$,Andromeda-method}
\alias{$<-,Andromeda-method}
\alias{[[<-,Andromeda-method}
\alias{[[,Andromeda-method}
\alias{names,Andromeda-method}
\alias{length,Andromeda-method}
\alias{close,Andromeda-method}
\title{The Andromeda class}
\usage{
\S4method{show}{Andromeda}(object)

\S4method{$}{Andromeda}(x, name)

\S4method{$}{Andromeda}(x, name) <- value

\S4method{[[}{Andromeda}(x, i) <- value

\S4method{[[}{Andromeda}(x, i)

\S4method{names}{Andromeda}(x)

\S4method{length}{Andromeda}(x)

\S4method{close}{Andromeda}(con, ...)
}
\arguments{
\item{object}{An \code{\link{Andromeda}} object.}

\item{x}{An \code{\link{Andromeda}} object.}

\item{name}{The name of a table in the \code{\link{Andromeda}} object.}

\item{value}{A data frame, \code{\link{Andromeda}} table, or other 'DBI' table.}

\item{i}{The name of a table in the \code{\link{Andromeda}} object.}

\item{con}{An \code{\link{Andromeda}} object.}

\item{...}{Included for compatibility with generic \code{close()} method.}
}
\value{
A vector of names.
}
\description{
The \code{Andromeda} class is an S4 object.

This class provides the ability to work with data objects in R that are too large to fit in memory. Instead,
these objects are stored on disk. This is slower than working from memory, but may be the only viable option.

Show the names of the tables in an Andromeda object.
}
\section{Tables}{

An \code{Andromeda} object has zero, one or more tables. The list of table names can be retrieved using the \code{\link[=names]{names()}}
method. Tables can be accessed using the dollar sign syntax, e.g. \code{andromeda$myTable}, or double-square-bracket
syntax, e.g. \code{andromeda[["myTable"]]}
}

\section{Permanence}{


To mimic the behavior of in-memory objects, when working with data in \code{Andromeda} the data is stored in a
temporary location on the disk. You can modify the data as you can see fit, and when needed can save the data
to a permanent location. Later this data can be loaded to a temporary location again and be read and modified,
while keeping the saved data as is.
}

\section{Inheritance}{


The \code{Andromeda} inherits directly from \code{SQLiteConnection.} As such, it can be used as if it is a \code{SQLiteConnection}.
\code{\link{RSQLite}} is an R wrapper around 'SQLite', a low-weight but very powerful single-user SQL database that can run
from a single file on the local file system.
}

\examples{
andr <- andromeda(cars = cars, iris = iris)

names(andr)
# [1] 'cars' 'iris'

close(andr)

}
\seealso{
\code{\link[=andromeda]{andromeda()}}
}
