% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plot.R
\name{qq_plot}
\alias{qq_plot}
\title{QQ Plots for Numerical Variables}
\usage{
qq_plot(data, color = "skyblue", subplot = FALSE, nrow = 2, margin = 0.1)
}
\arguments{
\item{data}{The input data frame containing numerical variables.}

\item{color}{The color of the QQ plot line (default: "skyblue").}

\item{subplot}{A logical argument (default: FALSE) indicating whether to create subplots.}

\item{nrow}{Number of rows for subplots (if subplot is TRUE, default: 2).}

\item{margin}{Margin for subplots (if subplot is TRUE, default: 0.1).}
}
\value{
A list of QQ plots.
}
\description{
This function generates QQ plots for all numerical variables in the input data frame.
QQ plots are valuable for assessing the distributional similarity between observed data
and a theoretical normal distribution. It acts as a guide, revealing deviations from the 
expected norm, outliers, and the contours of distribution tails.
}
\examples{
data(mtcars)
qq_plot(mtcars)

}
