% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam}
\alias{SimParam}
\title{Simulation parameters}
\description{
Container for global simulation parameters. Saving this object 
as SP will allow it to be accessed by function defaults.
}
\note{
By default the founder population is the population used to 
initalize the SimParam object. This population can be changed by 
replacing the population in the founderPop slot. You must run 
\code{\link{resetPop}} on any existing populations to obtain the 
new trait values.
}
\examples{

## ------------------------------------------------
## Method `SimParam$new`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

## ------------------------------------------------
## Method `SimParam$setTrackPed`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackPed(TRUE)

## ------------------------------------------------
## Method `SimParam$setTrackRec`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackRec(TRUE)

## ------------------------------------------------
## Method `SimParam$resetPed`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)
pop@id # 1:10

#Create another population after reseting pedigree
SP$resetPed()
pop2 = newPop(founderPop, simParam=SP)
pop2@id # 1:10

## ------------------------------------------------
## Method `SimParam$restrSegSites`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$restrSegSites(minQtlPerChr=5, minSnpPerChr=5)

## ------------------------------------------------
## Method `SimParam$setSexes`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setSexes("yes_sys")

## ------------------------------------------------
## Method `SimParam$addSnpChip`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChip(10)

## ------------------------------------------------
## Method `SimParam$addTraitA`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

## ------------------------------------------------
## Method `SimParam$addTraitAD`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)

## ------------------------------------------------
## Method `SimParam$addTraitAG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAG(10, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitADG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADG(10, meanDD=0.5, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitAE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

## ------------------------------------------------
## Method `SimParam$addTraitADE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADE(10)

## ------------------------------------------------
## Method `SimParam$addTraitAEG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAEG(10, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitADEG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADEG(10, meanDD=0.5, varGxE=2)

## ------------------------------------------------
## Method `SimParam$setVarE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

## ------------------------------------------------
## Method `SimParam$setCorE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=diag(2))
SP$setVarE(varE=c(1,1))
E = 0.5*diag(2)+0.5 #Positively correlated error
SP$setCorE(E)

## ------------------------------------------------
## Method `SimParam$rescaleTraits`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

#Change mean to 1
SP$rescaleTraits(mean=1)
#Run resetPop for change to take effect
pop = resetPop(pop, simParam=SP) 
meanG(pop)

## ------------------------------------------------
## Method `SimParam$setRecombRatio`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setRecombRatio(2) #Twice as much recombination in females
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{nThreads}}{number of threads used on platforms with OpenMP support}

\item{\code{snpChips}}{list of SNP chips}

\item{\code{invalidQtl}}{list of segregating sites that aren't valid QTL}

\item{\code{invalidSnp}}{list of segregating sites that aren't valid SNP}

\item{\code{founderPop}}{founder population used for variance scaling}

\item{\code{finalizePop}}{function applied to newly created populations.
Currently does nothing and should only be changed by expert users.}

\item{\code{v}}{the crossover interference parameter for a gamma model of 
recombination. A value of 1 indicates no crossover interference 
(e.g. Haldane mapping function). A value of 2.6 approximates the 
degree of crossover interference implied by the Kosambi mapping 
function. (default is 1)}

\item{\code{quadProb}}{the probability of quadrivalent pairing in an 
autopolyploid. (default is 0)}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{traits}}{list of traits}

\item{\code{nChr}}{number of chromosomes}

\item{\code{nTraits}}{number of traits}

\item{\code{nSnpChips}}{number of SNP chips}

\item{\code{segSites}}{segregating sites per chromosome}

\item{\code{sexes}}{sexes used for mating}

\item{\code{sepMap}}{are there seperate genetic maps for 
males and females}

\item{\code{genMap}}{"matrix" of chromosome genetic maps}

\item{\code{femaleMap}}{"matrix" of chromosome genetic maps for 
females}

\item{\code{maleMap}}{"matrix" of chromosome genetic maps for 
males}

\item{\code{centromere}}{position of centromeres genetic map}

\item{\code{femaleCentromere}}{position of centromeres on female 
genetic map}

\item{\code{maleCentromere}}{position of centromeres on male 
genetic map}

\item{\code{lastId}}{last ID number assigned}

\item{\code{isTrackPed}}{is pedigree being tracked}

\item{\code{pedigree}}{pedigree matrix for all individuals}

\item{\code{isTrackRec}}{is recombination being tracked}

\item{\code{recHist}}{list of historic recombination events}

\item{\code{varA}}{additive genetic variance in founderPop}

\item{\code{varG}}{total genetic variance in founderPop}

\item{\code{varE}}{default error variance}

\item{\code{version}}{the version of AlphaSimR used to generate this object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimParam$new()}}
\item \href{#method-setTrackPed}{\code{SimParam$setTrackPed()}}
\item \href{#method-setTrackRec}{\code{SimParam$setTrackRec()}}
\item \href{#method-resetPed}{\code{SimParam$resetPed()}}
\item \href{#method-restrSegSites}{\code{SimParam$restrSegSites()}}
\item \href{#method-setSexes}{\code{SimParam$setSexes()}}
\item \href{#method-addSnpChip}{\code{SimParam$addSnpChip()}}
\item \href{#method-addStructuredSnpChip}{\code{SimParam$addStructuredSnpChip()}}
\item \href{#method-addTraitA}{\code{SimParam$addTraitA()}}
\item \href{#method-addTraitAD}{\code{SimParam$addTraitAD()}}
\item \href{#method-addTraitAG}{\code{SimParam$addTraitAG()}}
\item \href{#method-addTraitADG}{\code{SimParam$addTraitADG()}}
\item \href{#method-addTraitAE}{\code{SimParam$addTraitAE()}}
\item \href{#method-addTraitADE}{\code{SimParam$addTraitADE()}}
\item \href{#method-addTraitAEG}{\code{SimParam$addTraitAEG()}}
\item \href{#method-addTraitADEG}{\code{SimParam$addTraitADEG()}}
\item \href{#method-manAddTrait}{\code{SimParam$manAddTrait()}}
\item \href{#method-switchTrait}{\code{SimParam$switchTrait()}}
\item \href{#method-removeTrait}{\code{SimParam$removeTrait()}}
\item \href{#method-setVarE}{\code{SimParam$setVarE()}}
\item \href{#method-setCorE}{\code{SimParam$setCorE()}}
\item \href{#method-rescaleTraits}{\code{SimParam$rescaleTraits()}}
\item \href{#method-setRecombRatio}{\code{SimParam$setRecombRatio()}}
\item \href{#method-switchGenMap}{\code{SimParam$switchGenMap()}}
\item \href{#method-switchFemaleMap}{\code{SimParam$switchFemaleMap()}}
\item \href{#method-switchMaleMap}{\code{SimParam$switchMaleMap()}}
\item \href{#method-addToRec}{\code{SimParam$addToRec()}}
\item \href{#method-updateLastId}{\code{SimParam$updateLastId()}}
\item \href{#method-addToPed}{\code{SimParam$addToPed()}}
\item \href{#method-clone}{\code{SimParam$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Starts the process of building a new simulation 
by creating a new SimParam object and assigning a founder 
population to the class. It is recommended that you save the 
object with the name "SP", because subsequent functions will 
check your global enviroment for an object of this name if 
their simParam arguments are NULL. This allows you to call 
these functions without explicitly supplying a simParam 
argument with every call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$new(founderPop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{founderPop}}{an object of \code{\link{MapPop-class}}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTrackPed"></a>}}
\if{latex}{\out{\hypertarget{method-setTrackPed}{}}}
\subsection{Method \code{setTrackPed()}}{
Sets pedigree tracking for the simulation. 
By default pedigree tracking is turned off. When turned on, 
the pedigree of all individuals created will be tracked, 
except those created by \code{\link{hybridCross}}. Turning 
off pedigree tracking will turn off recombination tracking 
if it is turned on.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackPed(isTrackPed, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isTrackPed}}{should pedigree tracking be on.}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackPed(TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTrackRec"></a>}}
\if{latex}{\out{\hypertarget{method-setTrackRec}{}}}
\subsection{Method \code{setTrackRec()}}{
Sets recombination tracking for the simulation.
By default recombination tracking is turned off. When turned
on recombination tracking will also turn on pedigree tracking.
Recombination tracking keeps records of all individuals created,
except those created by \code{\link{hybridCross}}, because their
pedigree is not tracked.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackRec(isTrackRec, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isTrackRec}}{should recombination tracking be on.}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackRec(TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetPed"></a>}}
\if{latex}{\out{\hypertarget{method-resetPed}{}}}
\subsection{Method \code{resetPed()}}{
Resets the internal lastId, the pedigree 
and recombination tracking (if in use) to the 
supplied lastId. Be careful using this function because 
it may introduce a bug if you use individuals from
the deleted portion of the pedigree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$resetPed(lastId = 0L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{last ID to include in pedigree}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)
pop@id # 1:10

#Create another population after reseting pedigree
SP$resetPed()
pop2 = newPop(founderPop, simParam=SP)
pop2@id # 1:10
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restrSegSites"></a>}}
\if{latex}{\out{\hypertarget{method-restrSegSites}{}}}
\subsection{Method \code{restrSegSites()}}{
Sets restrictions on which segregating sites 
can serve as SNP and/or QTL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$restrSegSites(
  minQtlPerChr = NULL,
  minSnpPerChr = NULL,
  overlap = FALSE,
  minSnpFreq = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minQtlPerChr}}{the minimum number of segSites for QTLs. 
Can be a single value or a vector values for each 
chromosome.}

\item{\code{minSnpPerChr}}{the minimum number of segSites for SNPs. 
Can be a single value or a vector values for each 
chromosome.}

\item{\code{overlap}}{should SNP and QTL sites be allowed to overlap.}

\item{\code{minSnpFreq}}{minimum allowable frequency for SNP loci. 
No minimum SNP frequency is used if value is NULL.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$restrSegSites(minQtlPerChr=5, minSnpPerChr=5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSexes"></a>}}
\if{latex}{\out{\hypertarget{method-setSexes}{}}}
\subsection{Method \code{setSexes()}}{
Changes how sexes are determined in the simulation. 
The default sexes is "no", indicating all individuals are hermaphrodites. 
To add sexes to the simulation, run this function with "yes_sys" or 
"yes_rand". The value "yes_sys" will systematically assign 
sexes to newly created individuals as first male and then female. 
Populations with an odd number of individuals will have one more male than 
female. The value "yes_rand" will randomly assign a sex to each
individual.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setSexes(sexes, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sexes}}{acceptable value are "no", "yes_sys", or 
"yes_rand"}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setSexes("yes_sys")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSnpChip"></a>}}
\if{latex}{\out{\hypertarget{method-addSnpChip}{}}}
\subsection{Method \code{addSnpChip()}}{
Randomly assigns eligble SNPs to a SNP chip
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addSnpChip(nSnpPerChr, minSnpFreq = NULL, refPop = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nSnpPerChr}}{number of SNPs per chromosome. 
Can be a single value or nChr values.}

\item{\code{minSnpFreq}}{minimum allowable frequency for SNP loci.
If NULL, no minimum frequency is used.}

\item{\code{refPop}}{reference population for calculating SNP 
frequency. If NULL, the founder population is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChip(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addStructuredSnpChip"></a>}}
\if{latex}{\out{\hypertarget{method-addStructuredSnpChip}{}}}
\subsection{Method \code{addStructuredSnpChip()}}{
Randomly selects the number of snps in structure and then
assigns them to chips based on structure
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addStructuredSnpChip(nSnpPerChr, structure, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nSnpPerChr}}{number of SNPs per chromosome. 
Can be a single value or nChr values.}

\item{\code{structure}}{a matrix.  Rows are snp chips, columns are chips.
If value is true then that snp is on that chip.}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitA"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitA}{}}}
\subsection{Method \code{addTraitA()}}{
Randomly assigns eligble QTLs for one or more additive traits. 
If simulating more than one trait, all traits will be pleiotrophic 
with correlated additive effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitA(
  nQtlPerChr,
  mean = 0,
  var = 1,
  corA = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAD"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitAD}{}}}
\subsection{Method \code{addTraitAD()}}{
Randomly assigns eligble QTLs for one or more traits with dominance. 
If simulating more than one trait, all traits will be pleiotrophic 
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAD(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If 
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAG"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitAG}{}}}
\subsection{Method \code{addTraitAG()}}{
Randomly assigns eligble QTLs for one ore more additive GxE traits. 
If simulating more than one trait, all traits will be pleiotrophic 
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corGxE = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAG(10, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADG"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitADG}{}}}
\subsection{Method \code{addTraitADG()}}{
Randomly assigns eligble QTLs for a trait with dominance and GxE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 1e-06,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single 
value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADG(10, meanDD=0.5, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAE"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitAE}{}}}
\subsection{Method \code{addTraitAE()}}{
Randomly assigns eligble QTLs for one or more additive and epistasis 
traits. If simulating more than one trait, all traits will be pleiotrophic 
with correlated additive effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  corA = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared 
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If 
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADE"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitADE}{}}}
\subsection{Method \code{addTraitADE()}}{
Randomly assigns eligble QTLs for one or more traits with dominance and 
epistasis. If simulating more than one trait, all traits will be pleiotrophic 
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared 
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If 
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADE(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAEG"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitAEG}{}}}
\subsection{Method \code{addTraitAEG()}}{
Randomly assigns eligble QTLs for one or more additive and epistasis 
GxE traits. If simulating more than one trait, all traits will be pleiotrophic 
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared 
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If 
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAEG(10, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADEG"></a>}}
\if{latex}{\out{\hypertarget{method-addTraitADEG}{}}}
\subsection{Method \code{addTraitADEG()}}{
Randomly assigns eligble QTLs for a trait with dominance, 
epistasis and GxE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 1e-06,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single 
value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared 
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADEG(10, meanDD=0.5, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-manAddTrait"></a>}}
\if{latex}{\out{\hypertarget{method-manAddTrait}{}}}
\subsection{Method \code{manAddTrait()}}{
Manually add a new trait to the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$manAddTrait(lociMap, varE = NA_real_, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lociMap}}{a new object descended from 
\code{\link{LociMap-class}}}

\item{\code{varE}}{default error variance for phenotype, optional}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchTrait"></a>}}
\if{latex}{\out{\hypertarget{method-switchTrait}{}}}
\subsection{Method \code{switchTrait()}}{
Switch a trait in the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchTrait(traitPos, lociMap, varE = NA_real_, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{traitPos}}{an integer indicate which trait to switch}

\item{\code{lociMap}}{a new object descended from 
\code{\link{LociMap-class}}}

\item{\code{varE}}{default error variance for phenotype, optional}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeTrait"></a>}}
\if{latex}{\out{\hypertarget{method-removeTrait}{}}}
\subsection{Method \code{removeTrait()}}{
Remove a trait from the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$removeTrait(traits, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{traits}}{an integer vector indicating which traits to remove}

\item{\code{force}}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setVarE"></a>}}
\if{latex}{\out{\hypertarget{method-setVarE}{}}}
\subsection{Method \code{setVarE()}}{
Defines a default value for error 
variances in the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setVarE(h2 = NULL, H2 = NULL, varE = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h2}}{a vector of desired narrow-sense heritabilities}

\item{\code{H2}}{a vector of desired broad-sense heritabilities}

\item{\code{varE}}{a vector or matrix of error variances}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setCorE"></a>}}
\if{latex}{\out{\hypertarget{method-setCorE}{}}}
\subsection{Method \code{setCorE()}}{
Defines a correlation structure for default 
error variances. You must call \code{setVarE} first to define 
the default error variances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setCorE(corE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corE}}{a correlation matrix for the error variances}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=diag(2))
SP$setVarE(varE=c(1,1))
E = 0.5*diag(2)+0.5 #Positively correlated error
SP$setCorE(E)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescaleTraits"></a>}}
\if{latex}{\out{\hypertarget{method-rescaleTraits}{}}}
\subsection{Method \code{rescaleTraits()}}{
Linearly scales all traits to achieve desired 
values of means and variances in the founder population.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$rescaleTraits(
  mean = 0,
  var = 1,
  varEnv = 0,
  varGxE = 1e-06,
  useVarA = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mean}}{a vector of new trait means}

\item{\code{var}}{a vector of new trait variances}

\item{\code{varEnv}}{a vector of new environmental variances}

\item{\code{varGxE}}{a vector of new GxE variances}

\item{\code{useVarA}}{tune according to additive genetic variance if true}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

#Change mean to 1
SP$rescaleTraits(mean=1)
#Run resetPop for change to take effect
pop = resetPop(pop, simParam=SP) 
meanG(pop)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setRecombRatio"></a>}}
\if{latex}{\out{\hypertarget{method-setRecombRatio}{}}}
\subsection{Method \code{setRecombRatio()}}{
Set the relative recombination rates between males 
and females. This allows for sex-specific recombination rates, 
under the assumption of equivalent recombination landscapes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setRecombRatio(femaleRatio)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{femaleRatio}}{relative ratio of recombination in females compared to 
males. A value of 2 indicate twice as much recombination in females. The 
value must be greater than 0. (default is 1)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setRecombRatio(2) #Twice as much recombination in females
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchGenMap"></a>}}
\if{latex}{\out{\hypertarget{method-switchGenMap}{}}}
\subsection{Method \code{switchGenMap()}}{
Replaces existing genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchGenMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing 
numeric vectors for the position of each segregating 
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere 
positions. If NULL, the centromere are assumed to 
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchFemaleMap"></a>}}
\if{latex}{\out{\hypertarget{method-switchFemaleMap}{}}}
\subsection{Method \code{switchFemaleMap()}}{
Replaces existing female genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchFemaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing 
numeric vectors for the position of each segregating 
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere 
positions. If NULL, the centromere are assumed to 
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchMaleMap"></a>}}
\if{latex}{\out{\hypertarget{method-switchMaleMap}{}}}
\subsection{Method \code{switchMaleMap()}}{
Replaces existing male genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchMaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing 
numeric vectors for the position of each segregating 
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere 
positions. If NULL, the centromere are assumed to 
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addToRec"></a>}}
\if{latex}{\out{\hypertarget{method-addToRec}{}}}
\subsection{Method \code{addToRec()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToRec(hist)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hist}}{new recombination history}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateLastId"></a>}}
\if{latex}{\out{\hypertarget{method-updateLastId}{}}}
\subsection{Method \code{updateLastId()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$updateLastId(lastId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{last ID assigned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addToPed"></a>}}
\if{latex}{\out{\hypertarget{method-addToPed}{}}}
\subsection{Method \code{addToPed()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToPed(lastId, mother, father, isDH)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{ID of last individual}

\item{\code{mother}}{vector of mother IDs}

\item{\code{father}}{vector of father IDs}

\item{\code{isDH}}{vector of DH indicators}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
