% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullQtlHaplo}
\alias{pullQtlHaplo}
\title{Pull QTL haplotypes}
\usage{
pullQtlHaplo(pop, trait = 1, haplo = "all", chr = NULL, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{trait}{an integer. Indicates which trait's
QTL haplotypes to retrieve.}

\item{haplo}{either "all" for all haplotypes or an integer
for a single set of haplotypes. Use a value of 1 for female
haplotyes and a value of 2 for male haplotypes.}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of QTL haplotypes.
}
\description{
Retrieves QTL haplotype data
}
\details{
#' @title Pull SNP haplotypes for multiple chips
#'
#' @description Retrieves SNP haplotype data for multiple snp
#'
#' @param pop an object of \code{\link{Pop-class}}
#' @param chips a vector. For each animal indicates what snp
#' chip to use
#' @param haplo either "all" for all haplotypes or an integer
#' for a single set of haplotypes. Use a value of 1 for female
#' haplotyes and a value of 2 for male haplotypes.
#' @param missing What value to use for missing
#' @param simParam an object of \code{\link{SimParam}}
#'
#' @return Returns a matrix of SNP haplotypes.
#' 
#' @export
pullMultipleSnpHaplo = function(pop, chips, haplo="all",
                                missing=9, simParam=NULL){
  if(is.null(simParam)){
    simParam = get("SP",envir=.GlobalEnv)
  }
  # I feel like the next line shouldn't be needed but I don't know
  # enough R! (dmoney)
  missing = as.integer(missing)
  allSnps = numeric(0)
  uniqueChips = unique(chips)
  for (c in uniqueChips){
    allSnps = sort(union(allSnps,simParam$snpChips[[c]]@lociLoc))
  }

  if (haplo == "all") {
    output = matrix(pop@nInd*2,length(allSnps),data=missing)
    if(class(pop)=="Pop"){
      rownames(output) = paste(rep(pop@id,each=pop@ploidy),
                               rep(1:pop@ploidy,pop@nInd),sep="_")
    }else{
      rownames(output) = paste(rep(1:pop@nInd,each=pop@ploidy),
                               rep(1:pop@ploidy,pop@nInd),sep="_")
    }
  }else{
    output = matrix(pop@nInd,length(allSnps),data=missing)
    if(class(pop)=="Pop"){
      rownames(output) = paste(pop@id,rep(haplo,pop@nInd),sep="_")
    }else{
      rownames(output) = paste(1:pop@nInd,rep(haplo,pop@nInd),sep="_")
    }
  }
  for (snpChip in uniqueChips){
    mask = allSnps %in% simParam$snpChips[[snpChip]]@lociLoc
    if (haplo == "all") {
      one = getHaplo(pop@geno,
                     simParam$snpChips[[snpChip]]@lociPerChr,
                     simParam$snpChips[[snpChip]]@lociLoc,
                     simParam$nThreads)
      one = convToImat(one)
      for (i in 1:pop@nInd){
        if (chips[i] == snpChip) {
          output[i*2-1,mask] = one[i*2-1,]
          output[i*2,mask] = one[i*2,]
        }
      }
    }
    else {
      one = getOneHaplo(pop@geno,
                        simParam$snpChips[[snpChip]]@lociPerChr,
                        simParam$snpChips[[snpChip]]@lociLoc,
                        as.integer(haplo),
                        simParam$nThreads)
      one = convToImat(one)
      for (i in 1:pop@nInd){
        if (chips[i] == snpChip) {
          output[i,mask] = one[i,]
          output[i,mask] = one[i,]
        }
      }
    }
  }

  colnames(output) = paste("SNP",1:ncol(output),sep="_")

  return(output)
}
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)
pullQtlHaplo(pop, simParam=SP)

}
