% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{DGP}
\alias{DGP}
\title{Data Generating Process}
\usage{
DGP(
  anno = NULL,
  beta = c(1, 2, 3),
  binary = FALSE,
  geno = NULL,
  include_residual = TRUE,
  indicator = FALSE,
  maf_range = c(0.001, 0.005),
  method = "none",
  n = 100,
  prop_anno = c(0.5, 0.4, 0.1),
  prop_causal = 1,
  random_signs = FALSE,
  random_var = 0,
  snps = 100,
  weights = c(1, 1, 1)
)
}
\arguments{
\item{anno}{Annotation vector, if providing genotypes. Should match the
number of columns in geno.}

\item{beta}{If method = "none", a (L x 1) coefficient with effect sizes for
each annotation category. By default, there are L = 3 annotation categories
corresponding to BMVs, DMVs, and PTVs. If method != "none", a scalar
effect size for the allelic series burden score.}

\item{binary}{Generate binary phenotype? Default: FALSE.}

\item{geno}{Genotype matrix, if providing genotypes.}

\item{include_residual}{Include residual? If FALSE, returns the expected
value. Intended for testing.}

\item{indicator}{Convert raw counts to indicators? Default: FALSE.}

\item{maf_range}{Range of minor allele frequencies: c(MIN, MAX).}

\item{method}{Genotype aggregation method. Default: "none".}

\item{n}{Sample size.}

\item{prop_anno}{Proportions of annotations in each category. Length should
equal the number of annotation categories. Default of c(0.5, 0.4, 0.1) is
based on the approximate empirical frequencies of BMVs, DMVs, and PTVs.}

\item{prop_causal}{Proportion of variants which are causal. Default: 1.0.}

\item{random_signs}{Randomize signs? FALSE for burden-type genetic
architecture, TRUE for SKAT-type.}

\item{random_var}{Frailty variance in the case of random signs. Default: 0.}

\item{snps}{Number of SNP in the gene. Default: 100.}

\item{weights}{Annotation category weights. Length should match \code{prop_anno}.}
}
\value{
List containing: genotypes, annotations, covariates, phenotypes.
}
\description{
Generate a data set consisting of:
\itemize{
\item \code{anno}: (snps x 1) annotation vector.
\item \code{covar}: (subjects x 6) covariate matrix.
\item \code{geno}: (subjects x snps) genotype matrix.
\item \code{pheno}: (subjects x 1) phenotype vector.
\item \code{type}: Either "binary" or "quantitative".
}
}
\examples{
# Generate data.
data <- DGP(n = 100)

# View components.
table(data$anno)
head(data$covar)
head(data$geno[, 1:5])
hist(data$pheno)
}
