% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEXP_analysis.R
\name{biexponential}
\alias{biexponential}
\title{Analysis: Biexponential}
\usage{
biexponential(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{Defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{Shape size}

\item{linesize}{Line size}

\item{pointshape}{Format point (default is 21)}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs biexponential regression analysis.
}
\details{
The biexponential model is defined by:
\deqn{y = A1 \times e^{-e^{lrc1 \cdot x}} + A2 \times e^{-e^{lrc2 \cdot x}}}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
biexponential(time,WL)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).
}
\seealso{
\link{asymptotic_neg}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
