% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc3fat_function.R
\name{desc3fat}
\alias{desc3fat}
\title{Descriptive: Descriptive analysis (Three factors)}
\usage{
desc3fat(
  f1,
  f2,
  f3,
  response,
  legend.title = "Legend",
  xlab = "",
  ylab = "Response",
  theme = theme_classic(),
  plot = "interaction"
)
}
\arguments{
\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{f3}{Numeric or complex vector with factor 3 levels}

\item{response}{Numerical vector containing the response of the experiment.}

\item{legend.title}{Legend title}

\item{xlab}{x name (Accepts the \emph{expression}() function)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot theme}

\item{plot}{"interaction" or "box"}
}
\value{
The function returns a triple interaction graph.
}
\description{
Performs the descriptive graphical analysis of an experiment with three factors of interest.
}
\examples{
library(AgroR)
data(enxofre)
with(enxofre, desc3fat(f1, f2, f3, resp))
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Descriptive}
\keyword{Experimental}
