% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentation_long.R
\name{fragmentation_long}
\alias{fragmentation_long}
\title{Fragmentation Metrics for Whole Dataset}
\usage{
fragmentation_long(count.data, weartime, thresh, bout.length = 1,
  metrics = c("mean_bout", "TP", "Gini", "power", "hazard", "all"),
  by = c("day", "subject"))
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n*1442 containing the 1440 minutes of activity data for all n subject days.
The first two columns have to be ID and Day. ID can be either \code{character} or \code{numeric}. Day has to be \code{numeric} indicating
the sequencey of days within each subject.}

\item{weartime}{\code{data.frame} with dimension of \code{count.data}.
The first two columns have to be ID and Day.ID can be either \code{character} or \code{numeric}. Day has to be \code{numeric} indicating
the sequencey of days within each subject.}

\item{thresh}{threshold to define the two states.}

\item{bout.length}{minimum duration of defining an active bout; defaults to 1.}

\item{metrics}{What is the fragmentation metrics to exract. Can be
"mean_bout","TP","Gini","power","hazard",or all the above metrics "all".}

\item{by}{Determine whether fragmentation is calcualted by day or by subjects (i.e. aggregate bouts across days).
by-subject is recommended to gain more power.}
}
\value{
A dataframe with some of the following columns
\item{ID}{identifier of the person}
\item{Day}{\code{numeric} vector indicating the sequencey of days within each subject. }
\item{mean_r}{mean sedentary bout duration}
\item{mean_a}{mean active bout duration}
\item{SATP}{sedentary to active transition probability}
\item{ASTP}{bactive to sedentary transition probability}
\item{Gini_r}{Gini index for active bout}
\item{Gini_a}{Gini index for sedentary bout}
\item{h_r}{hazard function for sedentary bout}
\item{h_a}{hazard function for active bout}
\item{alpha_r}{power law parameter for sedentary bout}
\item{alpha_a}{power law parameter for active bout}
}
\description{
Fragmentation methods to study the transition between two states, e.g.
sedentary v.s. active.This function is a whole dataset wrapper for \code{fragmentation}
}
\details{
Metrics include
mean_bout (mean bout duration),
TP (between states transition probability),
Gini (gini index),
power (alapha parameter for power law distribution)
hazard (average hazard function)
}
\examples{
data(example_activity_data)
count = example_activity_data$count
wear = example_activity_data$wear
frag_by_subject = fragmentation_long(count.data = count,
weartime = wear,thresh = 100,bout.length = 1,
metrics = "all",by = "subject")
frag_by_day = fragmentation_long(count.data = count,
weartime = wear,thresh = 100,bout.length = 1,
metrics = "all",by = "day")


}
