% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActCosinor_long.R
\name{ActCosinor_long}
\alias{ActCosinor_long}
\title{Cosinor Model for Circadian Rhythmicity for the Whole Dataset}
\usage{
ActCosinor_long(count.data, window = 1)
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n * (p+2) containing the
p dimensional activity data for all n subject days.
The first two columns have to be ID and Day. ID can be
either \code{character} or \code{numeric}. Day has to be \code{numeric} indicating
the sequency of days within each subject.}

\item{window}{since the caculation of M10 and L5 depends on the dimension of data, we need to include
window size as an argument.}
}
\value{
A \code{data.frame} with the following 5 columns
\item{ID}{ID}
\item{ndays}{number of days}
\item{mes}{mesor}
\item{amp}{amplitude}
\item{acro}{acrophase}
\item{acrotime}{acrophase in time domain (hour)}
}
\description{
A parametric approach to study circadian rhythmicity assuming cosinor shape.This function is a whole dataset
wrapper for \code{RA}.
}
\examples{
counts_1 = example_activity_data$count
cos_all_1 = ActCosinor_long(count.data = counts_1, window = 1)
counts_10 = cbind(counts_1[,1:2],
as.data.frame(t(apply(counts_1[,-c(1:2)], 1,
FUN = bin_data, window = 10, method = "average"))))
cos_all_10 = ActCosinor_long(count.data = counts_10, window = 10)
}
