% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActCosinor.R
\name{ActCosinor}
\alias{ActCosinor}
\title{Cosinor Model for Circadian Rhythmicity}
\usage{
ActCosinor(x, window = 1)
}
\arguments{
\item{x}{\code{vector} vector of dimension n*1440 which reprsents n days of 1440 minute activity data}

\item{window}{The calcuation needs to understand what is the window size of the data}
}
\value{
A list with elements
\item{mes}{mesor}
\item{amp}{amplitude}
\item{acro}{acrophase in negative radians}
\item{acrotime}{acrophase in time domain (hour)}
}
\description{
A parametric approach to study circadian rhythmicity assuming cosinor shape.
}
\examples{
count1 = c(t(example_activity_data$count[1,-c(1,2)]))
cos_coeff = ActCosinor(x = count1, window = 1)
}
