% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCues.R
\name{getBoundary}
\alias{getBoundary}
\title{Helper function for makeCues that splits the signal based on the envelope of the signal}
\usage{
getBoundary(Wave, smooth = 800)
}
\arguments{
\item{Wave}{A Wave object (see tuneR)}

\item{smooth}{A parameter for using the kernel smooth function provied by the package zoo.}
}
\value{
A vector with the sample numbers of the boundaries.
}
\description{
Helper function for makeCues that splits the signal based on the envelope of the signal
}
\examples{
       \dontrun{
       library(tuneR)
       Wave=readWave("MyWaveFile.wav")
       Boundaries=getBoundary(Wave,800)
       }
}
\author{
Denis Arnold
}
