% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Achilles.R
\name{optimizeAtlasCache}
\alias{optimizeAtlasCache}
\title{Optimize atlas cache}
\usage{
optimizeAtlasCache(
  connectionDetails,
  resultsDatabaseSchema,
  vocabDatabaseSchema = resultsDatabaseSchema,
  outputFolder = "output",
  sqlOnly = FALSE,
  verboseMode = TRUE,
  tempAchillesPrefix = "tmpach"
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package.}

\item{resultsDatabaseSchema}{Fully qualified name of database schema that we can write final
results to. Default is cdmDatabaseSchema. On SQL Server, this should
specifiy both the database and the schema, so for example, on SQL
Server, 'cdm_results.dbo'.}

\item{vocabDatabaseSchema}{String name of database schema that contains OMOP Vocabulary. Default
is cdmDatabaseSchema. On SQL Server, this should specifiy both the
database and the schema, so for example 'results.dbo'.}

\item{outputFolder}{Path to store logs and SQL files}

\item{sqlOnly}{TRUE = just generate SQL files, don't actually run, FALSE = run
Achilles}

\item{verboseMode}{Boolean to determine if the console will show all execution steps.
Default = TRUE}

\item{tempAchillesPrefix}{The prefix to use for the "temporary" (but actually permanent)
Achilles analyses tables. Default is "tmpach"}
}
\value{
The SQL statement executed to update cache tables is returned.
}
\description{
Optimize atlas cache
}
\details{
Post-processing, optimize data for atlas cache in separate table to help performance.
}
