% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASRgenomics.R
\docType{package}
\name{ASRgenomics}
\alias{ASRgenomics}
\title{ASRgenomics: A package with complementary genomic functions}
\description{
This package presents a series of molecular and genetic routines in the R
environment with the aim of assisting in analytical pipelines before and after
use of ASReml-R or another library to perform analyses such as Genomic Selection
(GS) or Genome-Wide Association Analyses (GWAS).

The main tasks considered are:
\itemize{
\item Preparing and exploring pedigree, phenotypic and genomic data.
\item Calculating and evaluating genomic matrices and their inverse.
\item Complementing and expanding results from genomic analyses.
}

The functions implemented consider aspects such as: filtering SNP data for
quality control; assessing a kinship matrix \eqn{\boldsymbol{K}} by
reporting diagnostics (statistics and plots); performing Principal
Component Analyses (PCA) based on
kinship or SNP matrices for understanding population structure;
calculating the genomic matrix \eqn{\boldsymbol{G}} and its inverse
and assessing their quality; matching pedigree- against genomic-based matrices;
tuning up a genomic matrix (bend, blend or align); and obtaining the hybrid
matrix \eqn{\boldsymbol{H}} as required with single-step GBLUP (ssGBLUP).

For the full manual please visit: \url{https://asreml.kb.vsni.co.uk/wp-content/uploads/sites/3/ASRgenomics_Manual.pdf}
}
