% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av.R
\name{as.av}
\alias{as.av}
\alias{av}
\alias{is.av}
\title{Transform Input to an Antiviral Drug ID}
\usage{
as.av(x, flag_multiple_results = TRUE, info = interactive(), ...)

is.av(x)
}
\arguments{
\item{x}{a \link{character} vector to determine to antiviral drug ID}

\item{flag_multiple_results}{a \link{logical} to indicate whether a note should be printed to the console that probably more than one antiviral drug code or name can be retrieved from a single input value.}

\item{info}{a \link{logical} to indicate whether a progress bar should be printed - the default is \code{TRUE} only in interactive mode}

\item{...}{arguments passed on to internal functions}
}
\value{
A \link{character} \link{vector} with additional class \code{\link{ab}}
}
\description{
Use this function to determine the antiviral drug code of one or more antiviral drugs. The data set \link{antivirals} will be searched for abbreviations, official names and synonyms (brand names).
}
\details{
All entries in the \link{antivirals} data set have three different identifiers: a human readable EARS-Net code (column \code{ab}, used by ECDC and WHONET), an ATC code (column \code{atc}, used by WHO), and a CID code (column \code{cid}, Compound ID, used by PubChem). The data set contains more than 5,000 official brand names from many different countries, as found in PubChem. Not that some drugs contain multiple ATC codes.

All these properties will be searched for the user input. The \code{\link[=as.av]{as.av()}} can correct for different forms of misspelling:
\itemize{
\item Wrong spelling of drug names (such as "acyclovir"), which corrects for most audible similarities such as f/ph, x/ks, c/z/s, t/th, etc.
\item Too few or too many vowels or consonants
\item Switching two characters (such as "aycclovir", often the case in clinical data, when doctors typed too fast)
\item Digitalised paper records, leaving artefacts like 0/o/O (zero and O's), B/8, n/r, etc.
}

Use the \code{\link[=av_property]{av_*}} functions to get properties based on the returned antiviral drug ID, see \emph{Examples}.

Note: the \code{\link[=as.av]{as.av()}} and \code{\link[=av_property]{av_*}} functions may use very long regular expression to match brand names of antimicrobial drugs. This may fail on some systems.
}
\section{Source}{

World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology: \url{https://www.whocc.no/atc_ddd_index/}

European Commission Public Health PHARMACEUTICALS - COMMUNITY REGISTER: \url{https://ec.europa.eu/health/documents/community-register/html/reg_hum_atc.htm}
}

\section{WHOCC}{

This package contains \strong{all ~550 antibiotic, antimycotic and antiviral drugs} and their Anatomical Therapeutic Chemical (ATC) codes, ATC groups and Defined Daily Dose (DDD) from the World Health Organization Collaborating Centre for Drug Statistics Methodology (WHOCC, \url{https://www.whocc.no}) and the Pharmaceuticals Community Register of the European Commission (\url{https://ec.europa.eu/health/documents/community-register/html/reg_hum_atc.htm}).

These have become the gold standard for international drug utilisation monitoring and research.

The WHOCC is located in Oslo at the Norwegian Institute of Public Health and funded by the Norwegian government. The European Commission is the executive of the European Union and promotes its general interest.

\strong{NOTE: The WHOCC copyright does not allow use for commercial purposes, unlike any other info from this package.} See \url{https://www.whocc.no/copyright_disclaimer/.}
}

\section{Reference Data Publicly Available}{

All data sets in this \code{AMR} package (about microorganisms, antibiotics, SIR interpretation, EUCAST rules, etc.) are publicly and freely available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. We also provide tab-separated plain text files that are machine-readable and suitable for input in any software program, such as laboratory information systems. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.
}

\examples{
# these examples all return "ACI", the ID of aciclovir:
as.av("J05AB01")
as.av("J 05 AB 01")
as.av("Aciclovir")
as.av("aciclo")
as.av("   aciclo 123")
as.av("ACICL")
as.av("ACI")
as.av("Virorax") # trade name
as.av("Zovirax") # trade name

as.av("acyklofir") # severe spelling error, yet works

# use av_* functions to get a specific properties (see ?av_property);
# they use as.av() internally:
av_name("J05AB01")
av_name("acicl")
}
\seealso{
\itemize{
\item \link{antivirals} for the \link{data.frame} that is being used to determine ATCs
\item \code{\link[=av_from_text]{av_from_text()}} for a function to retrieve antimicrobial drugs from clinical text (from health care records)
}
}
